"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelsToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _discover_app_state_container = require("../../application/main/state_management/discover_app_state_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/components/panels_toggle/panels_toggle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * An element of this component is created in DiscoverLayout
 * @param stateContainer
 * @param sidebarToggleState$
 * @param renderedIn
 * @param isChartAvailable
 * @constructor
 */
const PanelsToggle = ({
  stateContainer,
  sidebarToggleState$,
  renderedFor,
  isChartAvailable
}) => {
  var _sidebarToggleState$i;
  const isChartHidden = (0, _discover_app_state_container.useAppStateSelector)(state => Boolean(state.hideChart));
  const onToggleChart = (0, _react.useCallback)(() => {
    stateContainer.appState.update({
      hideChart: !isChartHidden
    });
  }, [stateContainer, isChartHidden]);
  const sidebarToggleState = (0, _useObservable.default)(sidebarToggleState$);
  const isSidebarCollapsed = (_sidebarToggleState$i = sidebarToggleState === null || sidebarToggleState === void 0 ? void 0 : sidebarToggleState.isCollapsed) !== null && _sidebarToggleState$i !== void 0 ? _sidebarToggleState$i : false;
  const isInsideHistogram = renderedFor === 'histogram';
  const isInsideDiscoverContent = !isInsideHistogram;
  const buttons = [...(isInsideHistogram && isSidebarCollapsed || isInsideDiscoverContent && isSidebarCollapsed && (isChartHidden || !isChartAvailable) ? [{
    label: _i18n.i18n.translate('discover.panelsToggle.showSidebarButton', {
      defaultMessage: 'Show sidebar'
    }),
    iconType: 'transitionLeftIn',
    'data-test-subj': 'dscShowSidebarButton',
    'aria-expanded': !isSidebarCollapsed,
    'aria-controls': 'discover-sidebar',
    onClick: () => {
      var _sidebarToggleState$t;
      return sidebarToggleState === null || sidebarToggleState === void 0 ? void 0 : (_sidebarToggleState$t = sidebarToggleState.toggle) === null || _sidebarToggleState$t === void 0 ? void 0 : _sidebarToggleState$t.call(sidebarToggleState, false);
    }
  }] : []), ...(isInsideHistogram || isInsideDiscoverContent && isChartAvailable && isChartHidden ? [{
    label: isChartHidden ? _i18n.i18n.translate('discover.panelsToggle.showChartButton', {
      defaultMessage: 'Show chart'
    }) : _i18n.i18n.translate('discover.panelsToggle.hideChartButton', {
      defaultMessage: 'Hide chart'
    }),
    iconType: isChartHidden ? 'transitionTopIn' : 'transitionTopOut',
    'data-test-subj': isChartHidden ? 'dscShowHistogramButton' : 'dscHideHistogramButton',
    'aria-expanded': !isChartHidden,
    'aria-controls': 'unifiedHistogramCollapsablePanel',
    onClick: onToggleChart
  }] : [])];
  if (!buttons.length) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.IconButtonGroup, {
    "data-test-subj": `dscPanelsToggle${isInsideHistogram ? 'InHistogram' : 'InPage'}`,
    legend: _i18n.i18n.translate('discover.panelsToggle.panelsVisibilityLegend', {
      defaultMessage: 'Panels visibility'
    }),
    buttonSize: "s",
    buttons: buttons,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
};
exports.PanelsToggle = PanelsToggle;