"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _stats_table = require("../../../common/components/stats_table");
var _index_data_visualizer_view = require("../../components/index_data_visualizer_view/index_data_visualizer_view");
var _index_based_expanded_row = require("../../../common/components/expanded_row/index_based_expanded_row");
var _use_data_visualizer_grid_data = require("../../hooks/use_data_visualizer_grid_data");
var _embeddable_field_stats_no_results = require("./embeddable_field_stats_no_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/grid_embeddable/embeddable_field_stats_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const restorableDefaults = (0, _index_data_visualizer_view.getDefaultDataVisualizerListState)();
const EmbeddableFieldStatsTableWrapper = props => {
  const {
    onTableUpdate,
    onAddFilter,
    onRenderComplete
  } = props;
  const [dataVisualizerListState, setDataVisualizerListState] = (0, _react.useState)(restorableDefaults);
  const onTableChange = (0, _react.useCallback)(update => {
    setDataVisualizerListState({
      ...dataVisualizerListState,
      ...update
    });
    if (onTableUpdate) {
      onTableUpdate(update);
    }
  }, [dataVisualizerListState, onTableUpdate]);
  const {
    configs,
    searchQueryLanguage,
    searchString,
    extendedColumns,
    progress,
    overallStats,
    overallStatsProgress,
    setLastRefresh
  } = (0, _use_data_visualizer_grid_data.useDataVisualizerGridData)(props, dataVisualizerListState);
  const totalCount = overallStats === null || overallStats === void 0 ? void 0 : overallStats.totalCount;
  (0, _react.useEffect)(() => {
    setLastRefresh(Date.now());
  }, [props === null || props === void 0 ? void 0 : props.lastReloadRequestTime, setLastRefresh]);
  const getItemIdToExpandedRowMap = (0, _react.useCallback)(function (itemIds, items) {
    return itemIds.reduce((m, fieldName) => {
      const item = items.find(fieldVisConfig => fieldVisConfig.fieldName === fieldName);
      if (item !== undefined) {
        m[fieldName] = /*#__PURE__*/_react.default.createElement(_index_based_expanded_row.IndexBasedDataVisualizerExpandedRow, {
          item: item,
          dataView: props.dataView,
          combinedQuery: {
            searchQueryLanguage,
            searchString
          },
          onAddFilter: onAddFilter,
          totalDocuments: props.totalDocuments,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 13
          }
        });
      }
      return m;
    }, {});
  }, [props.dataView, searchQueryLanguage, searchString, props.totalDocuments, onAddFilter]);
  (0, _react.useEffect)(() => {
    if (progress === 100 && onRenderComplete) {
      onRenderComplete();
    }
  }, [progress, onRenderComplete]);
  if (progress === 100 && configs.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_embeddable_field_stats_no_results.EmbeddableNoResultsEmptyPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_stats_table.DataVisualizerTable, {
    items: configs,
    pageState: dataVisualizerListState,
    updatePageState: onTableChange,
    getItemIdToExpandedRowMap: getItemIdToExpandedRowMap,
    extendedColumns: extendedColumns,
    showPreviewByDefault: props === null || props === void 0 ? void 0 : props.showPreviewByDefault,
    onChange: onTableUpdate,
    loading: progress < 100,
    overallStatsRunning: overallStatsProgress.isRunning,
    totalCount: totalCount,
    renderFieldName: props.renderFieldName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
};

// exporting as default so it be lazy-loaded
// eslint-disable-next-line import/no-default-export
var _default = exports.default = EmbeddableFieldStatsTableWrapper;
module.exports = exports.default;