"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../grid_embeddable/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/index_data_visualizer/embeddables/field_stats/field_stats_initializer_view_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const viewTypeOptions = [{
  id: _types.FieldStatsInitializerViewType.DATA_VIEW,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fieldStatsDashboardPanel.dataSourceSelector.dataViewLabel",
    defaultMessage: "Data view",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 7
    }
  }),
  iconType: 'visLine'
}, {
  id: _types.FieldStatsInitializerViewType.ESQL,
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.fieldStatsDashboardPanel.dataSourceSelector.esqlLabel",
    defaultMessage: "ES|QL",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }),
  iconType: 'visTable'
}];
const dataSourceLabel = _i18n.i18n.translate('xpack.dataVisualizer.fieldStatsDashboardPanel.dataSourceLabel', {
  defaultMessage: 'Data source'
});
const dataSourceAriaLabel = _i18n.i18n.translate('xpack.dataVisualizer.fieldStatsDashboardPanel.viewTypeLabel', {
  defaultMessage: 'Pick type of data source to use'
});
const DataSourceTypeSelector = ({
  value,
  onChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: dataSourceLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    "aria-label": dataSourceAriaLabel,
    options: viewTypeOptions,
    idSelected: value,
    onChange: onChange,
    legend: dataSourceAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
};
exports.DataSourceTypeSelector = DataSourceTypeSelector;