"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _fileUpload = require("@kbn/file-upload");
var _kibana_context = require("../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/index_selection/index_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const existsErrorText = _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameAlreadyExistsErrorMessage', {
  defaultMessage: 'Index name already exists'
});
const permissionErrorText = _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameNoPermissionErrorMessage', {
  defaultMessage: 'You do not have permission to create this index'
});
const IndexInput = ({
  setIndexName,
  setIndexValidationStatus,
  initialIndexName
}) => {
  const {
    services: {
      fileUpload
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const [indexNameLocal, setIndexNameLocal] = (0, _react.useState)(initialIndexName !== null && initialIndexName !== void 0 ? initialIndexName : '');
  const [indexNameError, setIndexNameError] = (0, _react.useState)('');
  const isMounted = (0, _useMountedState.default)();
  (0, _useDebounce.default)(async () => {
    setIndexValidationStatus(_fileUpload.STATUS.STARTED);
    if (indexNameLocal === '') {
      setIndexValidationStatus(_fileUpload.STATUS.COMPLETED);
      setIndexNameError('');
      setIndexName('');
      return;
    }
    const indexNameValid = isIndexNameValid(indexNameLocal);
    if (indexNameValid.error) {
      setIndexNameError(indexNameValid.error);
      return;
    }
    const [exists, canImport] = await Promise.all([fileUpload.checkIndexExists(indexNameLocal), fileUpload.hasImportPermission({
      checkCreateDataView: false,
      checkHasManagePipeline: true,
      indexName: indexNameLocal
    })]);
    if (!isMounted()) {
      return;
    }
    setIndexName(indexNameLocal);
    if (canImport === false) {
      setIndexNameError(permissionErrorText);
      setIndexValidationStatus(_fileUpload.STATUS.FAILED);
      return;
    }
    if (exists) {
      setIndexNameError(existsErrorText);
      setIndexValidationStatus(_fileUpload.STATUS.FAILED);
      return;
    }
    setIndexNameError('');
    setIndexValidationStatus(_fileUpload.STATUS.COMPLETED);
  }, 250, [indexNameLocal]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameLabel', {
      defaultMessage: 'New index name'
    }),
    isInvalid: indexNameError !== '',
    error: indexNameError,
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameContainsIllegalCharactersErrorMessage', {
      defaultMessage: 'Index names must be lowercase and can only contain hyphens and numbers.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: indexNameError !== '',
    fullWidth: true,
    value: indexNameLocal,
    onChange: e => setIndexNameLocal(e.target.value),
    "data-test-subj": "dataVisualizerFileIndexNameInput",
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameContainsIllegalCharactersErrorMessage', {
      defaultMessage: 'Add name to index'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
exports.IndexInput = IndexInput;
function isIndexNameValid(name) {
  const reg = new RegExp('[\\\\/*?"<>|\\s,#]+');
  if (name !== name.toLowerCase() ||
  // name should be lowercase
  name === '.' || name === '..' ||
  // name can't be . or ..
  name.match(/^[-_+]/) !== null ||
  // name can't start with these chars
  name.match(reg) !== null // name can't contain these chars
  ) {
    return {
      valid: false,
      error: _i18n.i18n.translate('xpack.dataVisualizer.file.importView.indexNameContainsIllegalCharactersErrorMessage', {
        defaultMessage: 'Index name contains illegal characters'
      })
    };
  }
  return {
    valid: true
  };
}