"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEditorOpener = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _shared_imports = require("./shared_imports");
var _data_view_editor_lazy = require("./components/data_view_editor_lazy");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/open_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getEditorOpener = ({
  core,
  searchClient,
  dataViews
}) => options => {
  const {
    uiSettings,
    overlays,
    docLinks,
    notifications,
    http,
    application
  } = core;
  const {
    Provider: KibanaReactContextProvider
  } = (0, _shared_imports.createKibanaReactContext)({
    uiSettings,
    docLinks,
    http,
    notifications,
    application,
    dataViews,
    overlays,
    searchClient
  });
  let overlayRef = null;
  const openEditor = ({
    onSave,
    onCancel = () => {},
    defaultTypeIsRollup = false,
    requireTimestampField = false,
    allowAdHocDataView = false,
    editData,
    onDuplicate,
    isDuplicating,
    getDataViewHelpText
  }) => {
    const closeEditor = () => {
      if (overlayRef) {
        overlayRef.close();
        overlayRef = null;
      }
    };
    const onSaveIndexPattern = indexPattern => {
      closeEditor();
      if (onSave) {
        onSave(indexPattern);
      }
    };
    overlayRef = overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(KibanaReactContextProvider, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_data_view_editor_lazy.DataViewEditorLazy, {
      onSave: onSaveIndexPattern,
      onCancel: () => {
        closeEditor();
        onCancel();
      },
      editData: editData,
      defaultTypeIsRollup: defaultTypeIsRollup,
      requireTimestampField: requireTimestampField,
      allowAdHocDataView: allowAdHocDataView,
      showManagementLink: Boolean(editData && editData.isPersisted()),
      onDuplicate: onDuplicate,
      isDuplicating: isDuplicating,
      getDataViewHelpText: getDataViewHelpText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 13
      }
    })), core), {
      hideCloseButton: true,
      size: 'l',
      // EUI TODO: This z-index override of EuiOverlayMask is a workaround, and ideally should be resolved with a cleaner UI/UX flow long-term
      maskProps: {
        style: 'z-index: 1004' // we need this flyout to be above the timeline flyout (which has a z-index of 1003)
      },
      'aria-labelledby': 'dataViewEditorFlyoutTitle'
    });
    return closeEditor;
  };
  return openEditor(options);
};
exports.getEditorOpener = getEditorOpener;