"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SideNavPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _use_layout_width = require("../../hooks/use_layout_width");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _update_tab_indices = require("../../utils/update_tab_indices");
var _handle_roving_index = require("../../utils/handle_roving_index");
var _use_scroll = require("../../hooks/use_scroll");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/side_nav/panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Side navigation panel that opens on mouse click if the primary menu item contains a submenu.
 * Shows only in expanded mode.
 */
const SideNavPanel = ({
  children,
  footer,
  openerNode
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const scrollStyles = (0, _use_scroll.useScroll)();
  const wrapperStyles = (0, _react2.css)`
    // > For instance, only plain or transparent panels can have a border and/or shadow.
    // source: https://eui.elastic.co/docs/components/containers/panel/
    box-sizing: border-box;
    border-right: ${euiTheme.border.width.thin} ${euiTheme.colors.borderBaseSubdued} solid;
    display: flex;
    flex-direction: column;
    width: ${_use_layout_width.SIDE_PANEL_WIDTH}px;
  `;
  const navigationPanelStyles = (0, _react2.css)`
    ${scrollStyles}
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    "aria-label": _i18n.i18n.translate('core.ui.chrome.sideNavigation.sidePanelAriaLabel', {
      defaultMessage: `Side panel for {label}`,
      values: {
        label: openerNode.label
      }
    }),
    borderRadius: "none"
    // Used in Storybook to limit the height of the panel
    ,
    className: "side-nav-panel",
    css: wrapperStyles,
    "data-test-subj": `side-navigation-panel side-navigation-panel_${openerNode.id}`,
    hasShadow: false,
    role: "region",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    css: navigationPanelStyles,
    "data-test-subj": "side-navigation-panel-content",
    onKeyDown: _handle_roving_index.handleRovingIndex,
    panelRef: ref => {
      if (ref) {
        const elements = (0, _get_focusable_elements.getFocusableElements)(ref);
        (0, _update_tab_indices.updateTabIndices)(elements);
      }
    },
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, children), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    "data-test-subj": "side-navigation-panel-footer",
    paddingSize: "none",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, footer));
};
exports.SideNavPanel = SideNavPanel;