"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderHelpMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _header_extension = require("./header_extension");
var _nav_link = require("./nav_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header_help_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buildDefaultContentLinks = ({
  kibanaDocLink,
  docLinks,
  helpSupportUrl
}) => [{
  title: _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuKibanaDocumentationTitle', {
    defaultMessage: 'Kibana documentation'
  }),
  href: kibanaDocLink
}, {
  title: _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuAskElasticTitle', {
    defaultMessage: 'Ask Elastic'
  }),
  href: helpSupportUrl
}, {
  title: _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuGiveFeedbackTitle', {
    defaultMessage: 'Give feedback'
  }),
  href: docLinks.links.kibana.feedback
}, {
  title: _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuOpenGitHubIssueTitle', {
    defaultMessage: 'Open an issue in GitHub'
  }),
  href: docLinks.links.kibana.createGithubIssue
}];
class HelpMenu extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "onMenuButtonClick", () => {
      this.setState({
        isOpen: !this.state.isOpen
      });
    });
    (0, _defineProperty2.default)(this, "closeMenu", () => {
      this.setState({
        isOpen: false
      });
    });
    this.state = {
      isOpen: false,
      helpExtension: undefined,
      helpSupportUrl: '',
      globalHelpExtensionMenuLinks: [],
      defaultContentLinks: []
    };
  }
  componentDidMount() {
    this.subscription = (0, _rxjs.combineLatest)(this.props.helpExtension$, this.props.helpSupportUrl$, this.props.globalHelpExtensionMenuLinks$, this.props.defaultContentLinks$).subscribe(([helpExtension, helpSupportUrl, globalHelpExtensionMenuLinks, defaultContentLinks]) => {
      this.setState({
        helpExtension,
        helpSupportUrl,
        globalHelpExtensionMenuLinks,
        defaultContentLinks: defaultContentLinks.length === 0 ? buildDefaultContentLinks({
          ...this.props,
          helpSupportUrl
        }) : defaultContentLinks
      });
    });
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
      this.subscription = undefined;
    }
  }
  render() {
    const {
      kibanaVersion,
      theme
    } = this.props;
    const defaultContent = this.renderDefaultContent();
    const globalCustomContent = this.renderGlobalCustomContent();
    const customContent = this.renderCustomContent();
    const euiThemePadding = (0, _react2.css)`
      padding: ${theme.euiTheme.size.s};
    `;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
      "aria-expanded": this.state.isOpen,
      "aria-haspopup": "true",
      "aria-label": _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuButtonAriaLabel', {
        defaultMessage: 'Help menu'
      }),
      onClick: this.onMenuButtonClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question",
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downRight",
      button: button,
      closePopover: this.closeMenu,
      "data-test-subj": "helpMenuButton",
      id: "headerHelpMenu",
      isOpen: this.state.isOpen,
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.chrome.headerGlobalNav.helpMenuTitle",
      defaultMessage: "Help",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 17
      }
    }))), !this.props.isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        textTransform: 'none'
      },
      "data-test-subj": "kbnVersionString",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "core.ui.chrome.headerGlobalNav.helpMenuVersion",
      defaultMessage: "v {version}",
      values: {
        version: kibanaVersion
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 189,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxWidth: 240
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 199,
        columnNumber: 9
      }
    }, globalCustomContent, defaultContent, customContent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      css: euiThemePadding,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 15
      }
    }), customContent)));
  }
  renderDefaultContent() {
    const {
      defaultContentLinks
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 7
      }
    }, defaultContentLinks.map(({
      href,
      title,
      onClick: _onClick,
      dataTestSubj
    }, i) => {
      const isLast = i === defaultContentLinks.length - 1;
      if (href && _onClick) {
        throw new Error('Only one of `href` and `onClick` should be provided for the help menu link.');
      }
      const hrefProps = href ? {
        href,
        target: '_blank'
      } : {};
      const onClick = () => {
        if (!_onClick) return;
        _onClick();
        this.closeMenu();
      };
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: i,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, hrefProps, {
        onClick: onClick,
        size: "s",
        flush: "left",
        "data-test-subj": dataTestSubj,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 236,
          columnNumber: 15
        }
      }), title), !isLast && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 27
        }
      }));
    }));
  }
  renderGlobalCustomContent() {
    const {
      navigateToUrl
    } = this.props;
    const {
      globalHelpExtensionMenuLinks
    } = this.state;
    return globalHelpExtensionMenuLinks.sort((a, b) => b.priority - a.priority).map((link, index) => {
      const {
        linkType,
        content: text,
        href,
        external,
        ...rest
      } = link;
      return createCustomLink(index, text, true, {
        href,
        onClick: external ? undefined : this.createOnClickHandler(href, navigateToUrl),
        ...rest
      });
    });
  }
  renderCustomContent() {
    const {
      helpExtension
    } = this.state;
    if (!helpExtension) {
      return null;
    }
    const {
      navigateToUrl
    } = this.props;
    const {
      appName,
      links,
      content
    } = helpExtension;
    const getFeedbackText = () => _i18n.i18n.translate('core.ui.chrome.headerGlobalNav.helpMenuGiveFeedbackOnApp', {
      defaultMessage: 'Give feedback on {appName}',
      values: {
        appName: helpExtension.appName
      }
    });
    const customLinks = links && links.map((link, index) => {
      const addSpacer = index < links.length - 1;
      switch (link.linkType) {
        case 'documentation':
          {
            const {
              linkType,
              ...rest
            } = link;
            return createCustomLink(index, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "core.ui.chrome.headerGlobalNav.helpMenuDocumentation",
              defaultMessage: "Documentation",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 292,
                columnNumber: 15
              }
            }), addSpacer, {
              target: '_blank',
              rel: 'noopener',
              ...rest
            });
          }
        case 'github':
          {
            const {
              linkType,
              labels,
              title,
              ...rest
            } = link;
            return createCustomLink(index, getFeedbackText(), addSpacer, {
              iconType: 'logoGithub',
              href: createGithubUrl(labels, title),
              target: '_blank',
              rel: 'noopener',
              ...rest
            });
          }
        case 'discuss':
          {
            const {
              linkType,
              ...rest
            } = link;
            return createCustomLink(index, getFeedbackText(), addSpacer, {
              iconType: 'editorComment',
              target: '_blank',
              rel: 'noopener',
              ...rest
            });
          }
        case 'custom':
          {
            const {
              linkType,
              content: text,
              href,
              external,
              ...rest
            } = link;
            return createCustomLink(index, text, addSpacer, {
              href,
              onClick: this.createOnClickHandler(href, navigateToUrl),
              ...rest
            });
          }
        default:
          break;
      }
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 339,
        columnNumber: 11
      }
    }, appName)), customLinks, content && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, customLinks && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 29
      }
    }), /*#__PURE__*/_react.default.createElement(_header_extension.HeaderExtension, {
      extension: domNode => content(domNode, {
        hideHelpMenu: this.closeMenu
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 13
      }
    })));
  }
  createOnClickHandler(href, navigate) {
    return event => {
      if (!(0, _nav_link.isModifiedOrPrevented)(event) && event.button === 0) {
        event.preventDefault();
        this.closeMenu();
        navigate(href);
      }
    };
  }
}
const createGithubUrl = (labels, title) => {
  const url = new URL('https://github.com/elastic/kibana/issues/new?');
  if (labels.length) {
    url.searchParams.set('labels', labels.join(','));
  }
  if (title) {
    url.searchParams.set('title', title);
  }
  return url.toString();
};
const createCustomLink = (index, text, addSpacer, buttonProps) => {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `helpButton${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 398,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, buttonProps, {
    size: "s",
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 7
    }
  }), text), addSpacer && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 402,
      columnNumber: 21
    }
  }));
};
const HeaderHelpMenu = exports.HeaderHelpMenu = (0, _eui.withEuiTheme)(HelpMenu);