"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "WORKPAD_CONTAINER_ID", {
  enumerable: true,
  get: function () {
    return _workpad_app.WORKPAD_CONTAINER_ID;
  }
});
exports.WorkpadApp = void 0;
var _reactRedux = require("react-redux");
var _app = require("../../state/selectors/app");
var _workpad = require("../../state/selectors/workpad");
var _workpad_app = require("./workpad_app.component");
var _workpad_telemetry = require("./workpad_telemetry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkpadAppComponent = (0, _workpad_telemetry.withElementsLoadedTelemetry)(_workpad_app.WorkpadApp);
const WorkpadApp = exports.WorkpadApp = (0, _reactRedux.connect)(state => ({
  isWriteable: (0, _workpad.isWriteable)(state) && (0, _app.canUserWrite)(state),
  workpad: (0, _workpad.getWorkpad)(state)
}))(WorkpadAppComponent);