"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasourcePreview = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = require("prop-types");
var _loading = require("../../loading");
var _canvas_expressions_service = require("../../../services/canvas_expressions_service");
var _datasource_preview = require("./datasource_preview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/datasource/datasource_preview/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatasourcePreview = props => {
  const [datatable, setDatatable] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    (0, _canvas_expressions_service.getCanvasExpressionService)().interpretAst({
      type: 'expression',
      chain: [props.function]
    }, {}).then(setDatatable);
  }, [props.function, setDatatable]);
  if (!datatable) {
    return /*#__PURE__*/_react.default.createElement(_loading.Loading, (0, _extends2.default)({}, props, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 12
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_datasource_preview.DatasourcePreview, (0, _extends2.default)({}, props, {
    datatable: datatable,
    setDatatable: setDatatable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 10
    }
  }));
};
exports.DatasourcePreview = DatasourcePreview;
DatasourcePreview.propTypes = {
  function: _propTypes.PropTypes.object
};