"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CefError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CefError extends Error {
  constructor(message) {
    super(message);
    (0, _defineProperty2.default)(this, "errorCode", _constants.GenerationErrorCode.CEF_ERROR);
    (0, _defineProperty2.default)(this, "attributes", void 0);
    this.attributes = {
      errorCode: this.errorCode,
      errorMessageWithLink: {
        linkText: 'cef-integration',
        link: 'https://www.elastic.co/docs/current/integrations/cef',
        errorMessage: '' // Will be set using translation in the UI.
      }
    };
  }
  sendResponse(res) {
    const body = {
      message: this.errorCode,
      attributes: this.attributes
    };
    return res.customError({
      statusCode: 501,
      body
    });
  }
}
exports.CefError = CefError;