"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateAutomaticImport = void 0;
var _react = _interopRequireWildcard(require("react"));
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _header = require("./header");
var _footer = require("./footer");
var _cel_configuration = require("./flyout/cel_configuration");
var _use_navigate = require("../../../common/hooks/use_navigate");
var _connector_step = require("./steps/connector_step");
var _integration_step = require("./steps/integration_step");
var _data_stream_step = require("./steps/data_stream_step");
var _review_step = require("./steps/review_step");
var _deploy_step = require("./steps/deploy_step");
var _state = require("./state");
var _telemetry = require("../telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/create_automatic_import.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stepNames = {
  1: 'Connector Step',
  2: 'Integration Step',
  3: 'DataStream Step',
  4: 'Review Step',
  5: 'Deploy Step'
};
const CreateAutomaticImport = exports.CreateAutomaticImport = /*#__PURE__*/_react.default.memo(() => {
  const [state, dispatch] = (0, _react.useReducer)(_state.reducer, _state.initialState);
  const navigate = (0, _use_navigate.useNavigate)();
  const stepName = stepNames[state.step];
  const telemetry = (0, _telemetry.useTelemetry)();
  (0, _react.useEffect)(() => {
    telemetry.reportAssistantOpen();
  }, [telemetry]);
  const isThisStepReadyToComplete = (0, _react.useMemo)(() => {
    if (state.step === 1) {
      return (0, _connector_step.isConnectorStepReadyToComplete)(state);
    } else if (state.step === 2) {
      return (0, _integration_step.isIntegrationStepReadyToComplete)(state);
    } else if (state.step === 3) {
      return (0, _data_stream_step.isDataStreamStepReadyToComplete)(state);
    } else if (state.step === 4) {
      return (0, _review_step.isReviewStepReadyToComplete)(state);
    }
    return false;
  }, [state]);
  const goBackStep = (0, _react.useCallback)(() => {
    if (state.step === 1) {
      navigate(_use_navigate.Page.landing);
    } else {
      dispatch({
        type: 'SET_STEP',
        payload: state.step - 1
      });
    }
  }, [navigate, dispatch, state.step]);
  const completeStep = (0, _react.useCallback)(() => {
    if (!isThisStepReadyToComplete) {
      // If the user tries to navigate to the next step without completing the current step.
      return;
    }
    telemetry.reportAssistantStepComplete({
      step: state.step,
      stepName
    });
    if (state.step === 3) {
      dispatch({
        type: 'SET_IS_GENERATING',
        payload: true
      });
    } else {
      dispatch({
        type: 'SET_STEP',
        payload: state.step + 1
      });
    }
  }, [telemetry, state.step, stepName, isThisStepReadyToComplete]);
  const actions = (0, _react.useMemo)(() => ({
    setStep: payload => {
      dispatch({
        type: 'SET_STEP',
        payload
      });
    },
    setConnector: payload => {
      dispatch({
        type: 'SET_CONNECTOR',
        payload
      });
    },
    setIntegrationSettings: payload => {
      dispatch({
        type: 'SET_INTEGRATION_SETTINGS',
        payload
      });
    },
    setIsGenerating: payload => {
      dispatch({
        type: 'SET_IS_GENERATING',
        payload
      });
    },
    setShowCelCreateFlyout: payload => {
      dispatch({
        type: 'SET_SHOW_CEL_CREATE_FLYOUT',
        payload
      });
    },
    setIsFlyoutGenerating: payload => {
      dispatch({
        type: 'SET_IS_FLYOUT_GENERATING',
        payload
      });
    },
    setResult: payload => {
      dispatch({
        type: 'SET_GENERATED_RESULT',
        payload
      });
    },
    setCelInputResult: payload => {
      dispatch({
        type: 'SET_CEL_INPUT_RESULT',
        payload
      });
    },
    completeStep
  }), [completeStep]);
  return /*#__PURE__*/_react.default.createElement(_state.ActionsProvider, {
    value: actions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header.Header, {
    currentStep: state.step,
    isGenerating: state.isGenerating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    grow: true,
    paddingSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, state.step === 1 && /*#__PURE__*/_react.default.createElement(_connector_step.ConnectorStep, {
    connector: state.connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 32
    }
  }), state.step === 2 && /*#__PURE__*/_react.default.createElement(_integration_step.IntegrationStep, {
    integrationSettings: state.integrationSettings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 32
    }
  }), state.step === 3 && /*#__PURE__*/_react.default.createElement(_data_stream_step.DataStreamStep, {
    integrationSettings: state.integrationSettings,
    celInputResult: state.celInputResult,
    connector: state.connector,
    isGenerating: state.isGenerating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 13
    }
  }), state.step === 3 && state.showCelCreateFlyout && /*#__PURE__*/_react.default.createElement(_cel_configuration.CreateCelConfigFlyout, {
    integrationSettings: state.integrationSettings,
    isFlyoutGenerating: state.isFlyoutGenerating,
    connector: state.connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }), state.step === 4 && /*#__PURE__*/_react.default.createElement(_review_step.ReviewStep, {
    integrationSettings: state.integrationSettings,
    isGenerating: state.isGenerating,
    result: state.result,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }), state.step === 5 && /*#__PURE__*/_react.default.createElement(_deploy_step.DeployStep, {
    integrationSettings: state.integrationSettings,
    result: state.result,
    celInputResult: state.celInputResult,
    connector: state.connector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    isGenerating: state.isGenerating,
    isAnalyzeStep: state.step === 3,
    isLastStep: state.step === 5,
    isNextStepEnabled: isThisStepReadyToComplete && !state.isGenerating,
    isNextAddingToElastic: state.step === 4,
    onBack: goBackStep,
    onNext: completeStep,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  })));
});
CreateAutomaticImport.displayName = 'CreateAutomaticImport';