"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColumns = getColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _apmUiShared = require("@kbn/apm-ui-shared");
var _get_comparison_options = require("../time_comparison/get_comparison_options");
var _formatters = require("../../../../common/utils/formatters");
var _style = require("../../../utils/style");
var _spark_plot = require("../charts/spark_plot");
var _error_detail_link = require("../links/apm/error_detail_link");
var _error_overview_link = require("../links/apm/error_overview_link");
var _truncate_with_tooltip = require("../truncate_with_tooltip");
var _get_timeseries_color = require("../charts/helper/get_timeseries_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/errors_table/get_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ErrorLink = (0, _styled.default)(_error_overview_link.ErrorOverviewLink)`
  ${(0, _style.truncate)('100%')};
`;
function getColumns({
  serviceName,
  errorGroupDetailedStatisticsLoading,
  errorGroupDetailedStatistics,
  comparisonEnabled,
  query,
  showErrorType = true
}) {
  const {
    offset
  } = query;
  return [...(showErrorType ? [{
    name: _i18n.i18n.translate('xpack.apm.errorsTable.typeColumnLabel', {
      defaultMessage: 'Type'
    }),
    field: 'type',
    sortable: false,
    render: (_, {
      type
    }) => {
      return /*#__PURE__*/_react.default.createElement(ErrorLink, {
        title: type,
        serviceName: serviceName,
        query: {
          ...query,
          kuery: `error.exception.type:"${type}"`
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 64,
          columnNumber: 17
        }
      }, type);
    }
  }] : []), {
    field: 'name',
    name: _i18n.i18n.translate('xpack.apm.errorsTable.columnName', {
      defaultMessage: 'Name'
    }),
    render: (_, {
      name,
      groupId: errorGroupId
    }) => {
      return /*#__PURE__*/_react.default.createElement(_truncate_with_tooltip.TruncateWithTooltip, {
        text: name,
        content: /*#__PURE__*/_react.default.createElement(_error_detail_link.ErrorDetailLink, {
          serviceName: serviceName,
          errorGroupId: errorGroupId,
          query: query,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 15
          }
        }, name),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'lastSeen',
    name: _i18n.i18n.translate('xpack.apm.errorsTable.columnLastSeen', {
      defaultMessage: 'Last seen'
    }),
    align: showErrorType ? _eui.RIGHT_ALIGNMENT : _eui.CENTER_ALIGNMENT,
    render: (_, {
      lastSeen
    }) => {
      return /*#__PURE__*/_react.default.createElement("span", {
        style: {
          overflow: 'hidden',
          whiteSpace: 'nowrap'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
        timestamp: lastSeen,
        timeUnit: "minutes",
        renderMode: "tooltip",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'occurrences',
    name: _i18n.i18n.translate('xpack.apm.errorsTable.columnOccurrences', {
      defaultMessage: 'Occurrences'
    }),
    align: _eui.RIGHT_ALIGNMENT,
    render: (_, {
      occurrences,
      groupId: errorGroupId
    }) => {
      var _errorGroupDetailedSt, _errorGroupDetailedSt2, _errorGroupDetailedSt3, _errorGroupDetailedSt4;
      const currentPeriodTimeseries = errorGroupDetailedStatistics === null || errorGroupDetailedStatistics === void 0 ? void 0 : (_errorGroupDetailedSt = errorGroupDetailedStatistics.currentPeriod) === null || _errorGroupDetailedSt === void 0 ? void 0 : (_errorGroupDetailedSt2 = _errorGroupDetailedSt[errorGroupId]) === null || _errorGroupDetailedSt2 === void 0 ? void 0 : _errorGroupDetailedSt2.timeseries;
      const previousPeriodTimeseries = errorGroupDetailedStatistics === null || errorGroupDetailedStatistics === void 0 ? void 0 : (_errorGroupDetailedSt3 = errorGroupDetailedStatistics.previousPeriod) === null || _errorGroupDetailedSt3 === void 0 ? void 0 : (_errorGroupDetailedSt4 = _errorGroupDetailedSt3[errorGroupId]) === null || _errorGroupDetailedSt4 === void 0 ? void 0 : _errorGroupDetailedSt4.timeseries;
      const {
        currentPeriodColor,
        previousPeriodColor
      } = (0, _get_timeseries_color.getTimeSeriesColor)(_get_timeseries_color.ChartType.ERROR_OCCURRENCES);
      return /*#__PURE__*/_react.default.createElement(_spark_plot.SparkPlot, {
        type: "bar",
        color: currentPeriodColor,
        isLoading: errorGroupDetailedStatisticsLoading,
        series: currentPeriodTimeseries,
        valueLabel: _i18n.i18n.translate('xpack.apm.errorsTable.occurrences', {
          defaultMessage: `{occurrences} occ.`,
          values: {
            occurrences: (0, _formatters.asInteger)(occurrences)
          }
        }),
        comparisonSeries: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriodTimeseries : undefined,
        comparisonSeriesColor: previousPeriodColor,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 11
        }
      });
    }
  }];
}