"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGE_SIZE = void 0;
exports.ServiceOverviewInstancesChartAndTable = ServiceOverviewInstancesChartAndTable;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _instances_latency_distribution_chart = require("../../../shared/charts/instances_latency_distribution_chart");
var _service_overview_instances_table = require("../service_overview_instances_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_instances_chart_and_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_STATE_MAIN_STATS = {
  currentPeriodItems: [],
  previousPeriodItems: [],
  requestId: undefined,
  currentPeriodItemsCount: 0
};
const INITIAL_STATE_DETAILED_STATISTICS = {
  currentPeriod: {},
  previousPeriod: {}
};
const PAGE_SIZE = exports.PAGE_SIZE = 5;
const DEFAULT_SORT = {
  direction: 'desc',
  field: 'throughput'
};
function ServiceOverviewInstancesChartAndTable({
  chartHeight,
  serviceName
}) {
  const {
    transactionType,
    transactionTypeStatus
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const [tableOptions, setTableOptions] = (0, _react.useState)({
    pageIndex: 0,
    sort: DEFAULT_SORT
  });
  const {
    pageIndex,
    sort
  } = tableOptions;
  const {
    direction,
    field
  } = sort;
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      comparisonEnabled,
      offset,
      latencyAggregationType
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/overview');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data: mainStatsData = INITIAL_STATE_MAIN_STATS,
    status: mainStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!transactionType && transactionTypeStatus === _use_fetcher.FETCH_STATUS.SUCCESS) {
      return Promise.resolve(INITIAL_STATE_MAIN_STATS);
    }
    if (!start || !end || !transactionType || !latencyAggregationType) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/service_overview_instances/main_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          latencyAggregationType: latencyAggregationType,
          start,
          end,
          transactionType,
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined,
          sortField: tableOptions.sort.field,
          sortDirection: tableOptions.sort.direction
        }
      }
    }).then(response => {
      var _response$currentPeri;
      return {
        // Everytime the main statistics is refetched, updates the requestId making the detailed API to be refetched.
        requestId: (0, _uuid.v4)(),
        currentPeriodItems: (_response$currentPeri = response === null || response === void 0 ? void 0 : response.currentPeriod) !== null && _response$currentPeri !== void 0 ? _response$currentPeri : [],
        currentPeriodItemsCount: response === null || response === void 0 ? void 0 : response.currentPeriod.length,
        previousPeriodItems: response === null || response === void 0 ? void 0 : response.previousPeriod
      };
    });
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [environment, kuery, latencyAggregationType, start, end, serviceName, transactionType, transactionTypeStatus, pageIndex, field, direction,
  // not used, but needed to trigger an update when offset is changed either manually by user or when time range is changed
  offset,
  // not used, but needed to trigger an update when comparison feature is disabled/enabled by user
  comparisonEnabled, tableOptions.sort]);
  const {
    currentPeriodItems,
    previousPeriodItems,
    requestId,
    currentPeriodItemsCount
  } = mainStatsData;
  const currentPageItems = currentPeriodItems.slice(pageIndex * PAGE_SIZE, (pageIndex + 1) * PAGE_SIZE);
  const {
    data: detailedStatsData = INITIAL_STATE_DETAILED_STATISTICS,
    status: detailedStatsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end || !transactionType || !latencyAggregationType || !currentPeriodItemsCount) {
      return;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/service_overview_instances/detailed_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          latencyAggregationType: latencyAggregationType,
          start,
          end,
          numBuckets: 20,
          transactionType,
          serviceNodeIds: JSON.stringify(currentPageItems.map(item => item.serviceNodeName)),
          offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
        }
      }
    });
  },
  // only fetches detailed statistics when requestId is invalidated by main statistics api call

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [requestId], {
    preservePreviousData: false
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_instances_latency_distribution_chart.InstancesLatencyDistributionChart, {
    height: chartHeight,
    items: currentPeriodItems,
    status: mainStatsStatus,
    comparisonItems: previousPeriodItems,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_instances_table.ServiceOverviewInstancesTable, {
    mainStatsItems: currentPageItems,
    mainStatsStatus: mainStatsStatus,
    mainStatsItemCount: currentPeriodItemsCount,
    detailedStatsLoading: (0, _use_fetcher.isPending)(detailedStatsStatus),
    detailedStatsData: detailedStatsData,
    serviceName: serviceName,
    tableOptions: tableOptions,
    isLoading: mainStatsStatus === _use_fetcher.FETCH_STATUS.LOADING,
    isNotInitiated: mainStatsStatus === _use_fetcher.FETCH_STATUS.NOT_INITIATED,
    onChangeTableOptions: newTableOptions => {
      var _newTableOptions$page, _newTableOptions$page2;
      setTableOptions({
        pageIndex: (_newTableOptions$page = (_newTableOptions$page2 = newTableOptions.page) === null || _newTableOptions$page2 === void 0 ? void 0 : _newTableOptions$page2.index) !== null && _newTableOptions$page !== void 0 ? _newTableOptions$page : 0,
        sort: newTableOptions.sort ? {
          field: newTableOptions.sort.field,
          direction: newTableOptions.sort.direction
        } : DEFAULT_SORT
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }))));
}