"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkIcon = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/pages/maintenance_windows/components/link_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LinkIcon = exports.LinkIcon = /*#__PURE__*/_react.default.memo(({
  ariaLabel,
  children,
  color,
  dataTestSubj,
  disabled,
  iconSide = 'left',
  iconSize = 's',
  iconType,
  onClick,
  ...rest
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    css: (0, _react2.css)`
          align-items: center;
          display: inline-flex;
          vertical-align: top;
          white-space: nowrap;
          flex-direction: ${iconSide === 'left' ? 'row' : 'row-reverse'};
        `,
    color: color,
    "data-test-subj": dataTestSubj,
    disabled: disabled,
    onClick: onClick,
    "aria-label": ariaLabel
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    css: iconSide === 'left' ? (0, _react2.css)`
                  margin-right: ${euiTheme.size.xs};
                ` : (0, _react2.css)`
                  flex-direction: row-reverse;

                  .euiIcon {
                    margin-left: ${euiTheme.size.xs};
                  }
                `,
    "data-test-subj": "link-icon",
    size: iconSize,
    type: iconType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "link-icon-label",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, children));
});
LinkIcon.displayName = 'LinkIcon';