"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rRuleRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("../../../rule/validation/validate_timezone/v1");
var _validation = require("../../validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rRuleRequestSchema = exports.rRuleRequestSchema = _configSchema.schema.object({
  dtstart: _configSchema.schema.string({
    validate: _validation.validateStartDateV1
  }),
  tzid: _configSchema.schema.string({
    validate: _v.validateTimezone
  }),
  freq: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(0), _configSchema.schema.literal(1), _configSchema.schema.literal(2), _configSchema.schema.literal(3), _configSchema.schema.literal(4)])),
  interval: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: interval => {
      if (!Number.isInteger(interval)) {
        return 'rRule interval must be an integer greater than 0';
      }
    },
    min: 1
  })),
  until: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _validation.validateEndDateV1
  })),
  count: _configSchema.schema.maybe(_configSchema.schema.number({
    validate: count => {
      if (!Number.isInteger(count)) {
        return 'rRule count must be an integer greater than 0';
      }
    },
    min: 1
  })),
  byweekday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
    minSize: 1,
    validate: _validation.validateRecurrenceByWeekdayV1
  })),
  bymonthday: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    min: 1,
    max: 31
  }), {
    minSize: 1
  })),
  bymonth: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    min: 1,
    max: 12
  }), {
    minSize: 1
  }))
});