"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getChangePointChartEmbeddableFactory = void 0;
var _constants = require("@kbn/aiops-change-point-detection/constants");
var _presentationUtil = require("@kbn/presentation-util");
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _presentationContainers = require("@kbn/presentation-containers");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _shared_components = require("../../shared_components");
var _initialize_change_point_controls = require("./initialize_change_point_controls");
var _get_dataview_references = require("../get_dataview_references");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/embeddables/change_point_chart/embeddable_change_point_chart_factory.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function injectReferences(state) {
  var _state$references;
  const serializedState = (0, _lodash.cloneDeep)(state.rawState);
  // inject the reference
  const dataViewIdRef = (_state$references = state.references) === null || _state$references === void 0 ? void 0 : _state$references.find(ref => ref.name === _constants.CHANGE_POINT_CHART_DATA_VIEW_REF_NAME);
  // if the serializedState already contains a dataViewId, we don't want to overwrite it. (Unsaved state can cause this)
  if (dataViewIdRef && serializedState && !serializedState.dataViewId) {
    serializedState.dataViewId = dataViewIdRef === null || dataViewIdRef === void 0 ? void 0 : dataViewIdRef.id;
  }
  return serializedState;
}
const getChangePointChartEmbeddableFactory = getStartServices => {
  const factory = {
    type: _constants.EMBEDDABLE_CHANGE_POINT_CHART_TYPE,
    buildEmbeddable: async ({
      initialState,
      finalizeApi,
      uuid,
      parentApi
    }) => {
      const [coreStart, pluginStart] = await getStartServices();
      const timeRangeManager = (0, _presentationPublishing.initializeTimeRangeManager)(initialState.rawState);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(initialState.rawState);
      const state = injectReferences(initialState);
      const changePointManager = (0, _initialize_change_point_controls.initializeChangePointControls)(state);
      const dataLoading$ = new _rxjs.BehaviorSubject(true);
      const blockingError$ = new _rxjs.BehaviorSubject(undefined);
      const dataViews$ = new _rxjs.BehaviorSubject([await pluginStart.data.dataViews.get(state.dataViewId)]);
      const filtersApi = (0, _presentationPublishing.apiPublishesFilters)(parentApi) ? parentApi : undefined;
      function serializeState() {
        const dataViewId = changePointManager.api.dataViewId.getValue();
        return {
          rawState: {
            ...titleManager.getLatestState(),
            ...timeRangeManager.getLatestState(),
            ...changePointManager.getLatestState()
          },
          references: (0, _get_dataview_references.getDataviewReferences)(dataViewId, _constants.CHANGE_POINT_CHART_DATA_VIEW_REF_NAME)
        };
      }
      const unsavedChangesApi = (0, _presentationContainers.initializeUnsavedChanges)({
        uuid,
        parentApi,
        serializeState,
        anyStateChange$: (0, _rxjs.merge)(titleManager.anyStateChange$, timeRangeManager.anyStateChange$, changePointManager.anyStateChange$),
        getComparators: () => {
          return {
            ..._presentationPublishing.titleComparators,
            ..._presentationPublishing.timeRangeComparators,
            ..._initialize_change_point_controls.changePointComparators
          };
        },
        onReset: lastSaved => {
          timeRangeManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          titleManager.reinitializeState(lastSaved === null || lastSaved === void 0 ? void 0 : lastSaved.rawState);
          if (lastSaved) changePointManager.reinitializeState(lastSaved.rawState);
        }
      });
      const api = finalizeApi({
        ...timeRangeManager.api,
        ...titleManager.api,
        ...changePointManager.api,
        ...unsavedChangesApi,
        getTypeDisplayName: () => _i18n.i18n.translate('xpack.aiops.changePointDetection.typeDisplayName', {
          defaultMessage: 'change point charts'
        }),
        isEditingEnabled: () => true,
        onEdit: async () => {
          (0, _presentationUtil.openLazyFlyout)({
            core: coreStart,
            parentApi,
            flyoutProps: {
              'data-test-subj': 'aiopsChangePointChartEmbeddableInitializer',
              'aria-labelledby': 'changePointConfig',
              focusedPanelId: uuid
            },
            loadContent: async ({
              closeFlyout
            }) => {
              const {
                EmbeddableChangePointUserInput
              } = await Promise.resolve().then(() => _interopRequireWildcard(require('./change_point_config_input')));
              return /*#__PURE__*/_react.default.createElement(EmbeddableChangePointUserInput, {
                coreStart: coreStart,
                pluginStart: pluginStart,
                onConfirm: result => {
                  changePointManager.api.updateUserInput(result);
                  closeFlyout();
                },
                onCancel: closeFlyout,
                input: changePointManager.getLatestState(),
                __self: void 0,
                __source: {
                  fileName: _jsxFileName,
                  lineNumber: 142,
                  columnNumber: 17
                }
              });
            }
          });
        },
        dataLoading$,
        blockingError$,
        dataViews$,
        serializeState
      });
      const ChangePointDetectionComponent = (0, _shared_components.getChangePointDetectionComponent)(coreStart, pluginStart);
      const onLoading = v => dataLoading$.next(v);
      const onRenderComplete = () => dataLoading$.next(false);
      const onError = error => blockingError$.next(error);
      return {
        api,
        Component: () => {
          if (!(0, _presentationPublishing.apiHasExecutionContext)(parentApi)) {
            throw new Error('Parent API does not have execution context');
          }
          const [dataViewId, viewType, fn, metricField, splitField, maxSeriesToPlot, partitions] = (0, _presentationPublishing.useBatchedPublishingSubjects)(api.dataViewId, api.viewType, api.fn, api.metricField, api.splitField, api.maxSeriesToPlot, api.partitions);
          const reload$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.skipWhile)(fetchContext => !fetchContext.isReload), (0, _rxjs.map)(fetchContext => Date.now())), []);
          const timeRange$ = (0, _react.useMemo)(() => (0, _presentationPublishing.fetch$)(api).pipe((0, _rxjs.map)(fetchContext => fetchContext.timeRange), (0, _rxjs.distinctUntilChanged)(_fastDeepEqual.default)), []);
          const lastReloadRequestTime = (0, _useObservable.default)(reload$, Date.now());
          const timeRange = (0, _useObservable.default)(timeRange$, undefined);
          const embeddingOrigin = (0, _presentationPublishing.apiHasExecutionContext)(parentApi) ? parentApi.executionContext.type : undefined;
          return /*#__PURE__*/_react.default.createElement(ChangePointDetectionComponent, {
            filtersApi: filtersApi,
            viewType: viewType,
            timeRange: timeRange,
            fn: fn,
            metricField: metricField,
            splitField: splitField,
            maxSeriesToPlot: maxSeriesToPlot,
            dataViewId: dataViewId,
            partitions: partitions,
            onLoading: onLoading,
            onRenderComplete: onRenderComplete,
            onError: onError,
            embeddingOrigin: embeddingOrigin,
            lastReloadRequestTime: lastReloadRequestTime,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 215,
              columnNumber: 13
            }
          });
        }
      };
    }
  };
  return factory;
};
exports.getChangePointChartEmbeddableFactory = getChangePointChartEmbeddableFactory;