"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogCategorizationEmbeddable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _use_table_state = require("@kbn/ml-in-memory-table/hooks/use_table_state");
var _constants = require("@kbn/aiops-common/constants");
var _datemath = _interopRequireDefault(require("@elastic/datemath"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _dataService = require("@kbn/data-service");
var _use_filters_query = require("../../../hooks/use_filters_query");
var _use_search = require("../../../hooks/use_search");
var _log_pattern_analysis = require("../../../application/url_state/log_pattern_analysis");
var _use_data = require("../../../hooks/use_data");
var _use_aiops_app_context = require("../../../hooks/use_aiops_app_context");
var _use_categorize_request = require("../use_categorize_request");
var _category_table = require("../category_table");
var _loading_categorization = require("../loading_categorization");
var _use_validate_category_field = require("../use_validate_category_field");
var _use_minimum_time_range = require("./use_minimum_time_range");
var _category_validation_callout = require("../category_validation_callout");
var _use_actions = require("../category_table/use_actions");
var _information_text = require("../information_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/log_categorization/log_categorization_for_embeddable/log_categorization_for_embeddable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BAR_TARGET = 20;
const LogCategorizationEmbeddable = ({
  dataView,
  savedSearch,
  fieldName,
  minimumTimeRangeOption,
  randomSamplerMode,
  randomSamplerProbability,
  onChange,
  onRenderComplete,
  timeRange,
  lastReloadRequestTime
}) => {
  var _documentStats$docume2, _data$categories$leng, _data$categories2;
  const {
    notifications: {
      toasts
    },
    data: {
      query: {
        filterManager
      }
    },
    uiSettings,
    embeddingOrigin
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    filters,
    query
  } = (0, _use_filters_query.useFilterQueryUpdates)();
  const {
    runValidateFieldRequest,
    cancelRequest: cancelValidationRequest
  } = (0, _use_validate_category_field.useValidateFieldRequest)();
  const {
    getMinimumTimeRange,
    cancelRequest: cancelWiderTimeRangeRequest
  } = (0, _use_minimum_time_range.useMinimumTimeRange)();
  const isMounted = (0, _useMountedState.default)();
  const {
    runCategorizeRequest,
    cancelRequest: cancelCategorizationRequest,
    randomSampler
  } = (0, _use_categorize_request.useCategorizeRequest)({
    randomSamplerMode,
    setRandomSamplerMode: () => {},
    randomSamplerProbability,
    setRandomSamplerProbability: () => {}
  });
  const appState = (0, _log_pattern_analysis.getDefaultLogCategorizationAppState)({
    searchQuery: (0, _esQuery.buildEsQuery)(dataView, query !== null && query !== void 0 ? query : [], filters !== null && filters !== void 0 ? filters : [], uiSettings ? (0, _dataService.getEsQueryConfig)(uiSettings) : undefined),
    filters
  });
  const {
    searchQuery
  } = (0, _use_search.useSearch)({
    dataView,
    savedSearch: savedSearch !== null && savedSearch !== void 0 ? savedSearch : null
  }, appState, true);
  const [selectedCategories, setSelectedCategories] = (0, _react.useState)([]);
  const [loading, setLoading] = (0, _react.useState)(null);
  const [eventRate, setEventRate] = (0, _react.useState)([]);
  const [data, setData] = (0, _react.useState)(null);
  const [fieldValidationResult, setFieldValidationResult] = (0, _react.useState)(null);
  const tableState = (0, _use_table_state.useTableState)([], 'key');
  (0, _react.useEffect)(function initFields() {
    setLoading(null);
  }, [dataView]);
  const cancelRequest = (0, _react.useCallback)(() => {
    cancelWiderTimeRangeRequest();
    cancelValidationRequest();
    cancelCategorizationRequest();
    setLoading(false);
  }, [cancelCategorizationRequest, cancelValidationRequest, cancelWiderTimeRangeRequest]);
  (0, _react.useEffect)(function cancelRequestOnLeave() {
    return () => {
      cancelRequest();
    };
  }, [cancelRequest]);
  const timeRangeParsed = (0, _react.useMemo)(() => {
    if (timeRange) {
      const min = _datemath.default.parse(timeRange.from);
      const max = _datemath.default.parse(timeRange.to);
      if (min && max) {
        return {
          min,
          max
        };
      }
    }
  }, [timeRange]);
  const {
    documentStats,
    timefilter,
    earliest,
    latest,
    intervalMs,
    forceRefresh
  } = (0, _use_data.useData)(dataView, 'log_categorization', searchQuery, () => {}, undefined, undefined, BAR_TARGET, false, timeRangeParsed);
  const onAddFilter = (0, _react.useCallback)((values, alias) => {
    const filter = (0, _esQuery.buildEmptyFilter)(false, dataView.id);
    if (alias) {
      filter.meta.alias = alias;
    }
    filter.query = values.query;
    filterManager.addFilters([filter]);
  }, [dataView.id, filterManager]);
  const {
    getActions
  } = (0, _use_actions.useActions)(dataView.id, dataView.fields.find(field => field.name === fieldName), selectedCategories, appState, timefilter, onAddFilter, undefined);
  const loadCategories = (0, _react.useCallback)(async () => {
    const {
      getIndexPattern,
      timeFieldName: timeField
    } = dataView;
    const index = getIndexPattern();
    if (loading === true || fieldName === null || fieldName === undefined || timeField === undefined || earliest === undefined || latest === undefined || minimumTimeRangeOption === undefined || isMounted() !== true) {
      return;
    }
    cancelRequest();
    setLoading(true);
    setData(null);
    setFieldValidationResult(null);
    const additionalFilter = {
      from: earliest,
      to: latest
    };
    const runtimeMappings = dataView.getRuntimeMappings();
    try {
      const minTimeRange = await getMinimumTimeRange(index, timeField, additionalFilter, minimumTimeRangeOption, searchQuery, runtimeMappings);
      if (isMounted() !== true) {
        return;
      }
      const [validationResult, categorizationResult] = await Promise.all([runValidateFieldRequest(index, fieldName, timeField, minTimeRange, searchQuery, runtimeMappings, {
        [_constants.AIOPS_ANALYSIS_RUN_ORIGIN]: embeddingOrigin
      }), runCategorizeRequest(index, fieldName, timeField, {
        to: minTimeRange.to,
        from: minTimeRange.from
      }, searchQuery, runtimeMappings, intervalMs, minTimeRange.useSubAgg ? additionalFilter : undefined)]);
      if (isMounted() !== true) {
        return;
      }
      setFieldValidationResult(validationResult);
      const {
        categories,
        hasExamples
      } = categorizationResult;
      if (minTimeRange.useSubAgg) {
        const categoriesInBucket = categorizationResult.categories.map(category => {
          var _category$subFieldCou;
          return {
            ...category,
            count: (_category$subFieldCou = category.subFieldCount) !== null && _category$subFieldCou !== void 0 ? _category$subFieldCou : category.subTimeRangeCount,
            examples: category.subFieldExamples,
            sparkline: category.subFieldSparkline
          };
        }).filter(category => category.count > 0).sort((a, b) => b.count - a.count);
        setData({
          categories: categoriesInBucket,
          displayExamples: hasExamples,
          totalCategories: categories.length
        });
      } else {
        setData({
          categories,
          displayExamples: hasExamples,
          totalCategories: categories.length
        });
      }
    } catch (error) {
      if (error.name !== 'AbortError') {
        toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.aiops.logCategorization.errorLoadingCategories', {
            defaultMessage: 'Error loading categories'
          })
        });
      }
    }
    if (isMounted() === true) {
      setLoading(false);
    }
  }, [cancelRequest, dataView, earliest, embeddingOrigin, fieldName, getMinimumTimeRange, intervalMs, isMounted, latest, loading, minimumTimeRangeOption, runCategorizeRequest, runValidateFieldRequest, searchQuery, toasts]);
  (0, _react.useEffect)(function setOnChange() {
    if (typeof onChange === 'function') {
      var _data$categories;
      onChange((_data$categories = data === null || data === void 0 ? void 0 : data.categories) !== null && _data$categories !== void 0 ? _data$categories : []);
    }
  }, [data, onChange]);
  (0, _react.useEffect)(function triggerAnalysis() {
    var _documentStats$docume;
    const buckets = (_documentStats$docume = documentStats.documentCountStats) === null || _documentStats$docume === void 0 ? void 0 : _documentStats$docume.buckets;
    if (buckets === undefined) {
      return;
    }
    randomSampler.setDocCount(documentStats.totalCount);
    setEventRate(Object.entries(buckets).map(([key, docCount]) => ({
      key: +key,
      docCount
    })));
    loadCategories();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [randomSampler, (_documentStats$docume2 = documentStats.documentCountStats) === null || _documentStats$docume2 === void 0 ? void 0 : _documentStats$docume2.buckets, documentStats.totalCount, dataView.name, fieldName, minimumTimeRangeOption, randomSamplerMode, randomSamplerProbability]);
  (0, _react.useEffect)(function refreshTriggeredFromButton() {
    if (lastReloadRequestTime !== undefined) {
      cancelRequest();
      forceRefresh();
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [lastReloadRequestTime]);
  const isCasesEmbeddable = embeddingOrigin === _constants.AIOPS_EMBEDDABLE_ORIGIN.CASES;

  // When in cases, we can only show the "Filter for pattern in Discover" actions as Cases does not have full filter management.
  const actions = isCasesEmbeddable ? getActions(true) : [...getActions(false), ...getActions(true)];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_category_validation_callout.FieldValidationCallout, {
    validationResults: fieldValidationResult,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 7
    }
  }), (loading !== null && loading !== void 0 ? loading : true) === true ? /*#__PURE__*/_react.default.createElement(_loading_categorization.LoadingCategorization, (0, _extends2.default)({}, !isCasesEmbeddable ? {
    onCancel: cancelRequest
  } : {}, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 9
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_information_text.InformationText, {
    loading: loading !== null && loading !== void 0 ? loading : true,
    categoriesLength: (_data$categories$leng = data === null || data === void 0 ? void 0 : (_data$categories2 = data.categories) === null || _data$categories2 === void 0 ? void 0 : _data$categories2.length) !== null && _data$categories$leng !== void 0 ? _data$categories$leng : null,
    eventRateLength: eventRate.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 7
    }
  }), loading === false && data !== null && data.categories.length > 0 && fieldName !== null ? /*#__PURE__*/_react.default.createElement(_category_table.CategoryTable, {
    categories: data.categories,
    eventRate: eventRate,
    enableRowActions: false,
    displayExamples: data.displayExamples,
    setSelectedCategories: setSelectedCategories,
    tableState: tableState,
    selectable: false,
    actions: actions,
    onRenderComplete: onRenderComplete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 9
    }
  }) : null);
};

// eslint-disable-next-line import/no-default-export
exports.LogCategorizationEmbeddable = LogCategorizationEmbeddable;
var _default = exports.default = LogCategorizationEmbeddable;