"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _change_point_detection_context = require("./change_point_detection_context");
var _use_aiops_app_context = require("../../hooks/use_aiops_app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/metric_field_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MetricFieldSelector = exports.MetricFieldSelector = /*#__PURE__*/_react.default.memo(({
  value,
  onChange,
  inline = true
}) => {
  var _fieldStats$useFieldS;
  const {
    fieldStats
  } = (0, _use_aiops_app_context.useAiopsAppContext)();
  const {
    metricFieldOptions
  } = (0, _change_point_detection_context.useChangePointDetectionControlsContext)();
  const {
    renderOption,
    closeFlyout
  } = (_fieldStats$useFieldS = fieldStats === null || fieldStats === void 0 ? void 0 : fieldStats.useFieldStatsTrigger()) !== null && _fieldStats$useFieldS !== void 0 ? _fieldStats$useFieldS : {};
  const options = (0, _react.useMemo)(() => {
    return metricFieldOptions.map(v => {
      return {
        value: v.name,
        label: v.displayName,
        field: {
          id: v.name,
          type: v.type
        }
      };
    });
  }, [metricFieldOptions]);
  const selection = options.filter(v => v.value === value);
  const onChangeCallback = (0, _react.useCallback)(selectedOptions => {
    const option = selectedOptions[0];
    if (typeof option !== 'undefined') {
      onChange(option.value);
    }
    if (closeFlyout) {
      closeFlyout();
    }
  }, [onChange, closeFlyout]);
  const label = _i18n.i18n.translate('xpack.aiops.changePointDetection.selectMetricFieldLabel', {
    defaultMessage: 'Metric field'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: inline ? undefined : label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    prepend: inline ? label : undefined,
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selection,
    onChange: onChangeCallback,
    isClearable: false,
    "data-test-subj": "aiopsChangePointMetricField",
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  })));
});