"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortAndTruncateAnalyzedFields = sortAndTruncateAnalyzedFields;
var _lodash = require("lodash");
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sortAndTruncateAnalyzedFields(analysis, options = {}) {
  const {
    dropEmpty = false,
    dropUnmapped = false
  } = options;
  const {
    fields,
    ...meta
  } = analysis;
  const [nonEmptyFields, emptyFields] = (0, _lodash.partition)(analysis.fields, field => !field.empty);

  // randomize field selection to get a somewhat more illustrative set of fields when
  // the # of fields exceeds the threshold, instead of alphabetically sorted
  // additionally, prefer non-empty fields over empty fields
  const sortedFields = [...(0, _lodash.shuffle)(nonEmptyFields), ...(0, _lodash.shuffle)(emptyFields)];
  const filteredFields = dropEmpty || dropUnmapped ? sortedFields.filter(field => {
    const shouldBeDropped = dropEmpty && field.empty || dropUnmapped && field.types.length === 0;
    return !shouldBeDropped;
  }) : fields;
  return {
    ...meta,
    fields: (0, _inferenceCommon.truncateList)(filteredFields.map(field => {
      const types = field.types.join(',') || '(unnmapped)';
      let label = `${field.name}:${types}`;
      if (field.empty) {
        return `${field.name} (empty)`;
      }
      label += ` - ${field.cardinality} distinct values`;
      if (field.name === '@timestamp' || field.name === 'event.ingested') {
        return `${label}`;
      }
      const shortValues = field.values.filter(value => {
        return String(value).length <= 1024;
      });
      if (shortValues.length) {
        return `${label} (${(0, _inferenceCommon.truncateList)(shortValues.map(value => '`' + value + '`'), field.types.includes('text') || field.types.includes('match_only_text') ? 2 : 10).join(', ')})`;
      }
      return label;
    }), 500).sort()
  };
}