"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _popover = require("../popover");
var _beacon = require("../beacon");
var _tour_header = require("./_tour_header");
var _tour_footer = require("./_tour_footer");
var _tour = require("./tour.styles");
var _react2 = require("@emotion/react");
var _excluded = ["anchorPosition", "anchor", "children", "className", "css", "closePopover", "content", "isStepOpen", "minWidth", "maxWidth", "onFinish", "step", "stepsTotal", "subtitle", "title", "decoration", "footerAction", "panelProps", "panelClassName"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
var EuiTourStep = exports.EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
    anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
    anchor = _ref.anchor,
    children = _ref.children,
    className = _ref.className,
    css = _ref.css,
    _ref$closePopover = _ref.closePopover,
    closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
    content = _ref.content,
    _ref$isStepOpen = _ref.isStepOpen,
    isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
    _ref$minWidth = _ref.minWidth,
    minWidth = _ref$minWidth === void 0 ? 300 : _ref$minWidth,
    _ref$maxWidth = _ref.maxWidth,
    maxWidth = _ref$maxWidth === void 0 ? 600 : _ref$maxWidth,
    onFinish = _ref.onFinish,
    _ref$step = _ref.step,
    step = _ref$step === void 0 ? 1 : _ref$step,
    stepsTotal = _ref.stepsTotal,
    subtitle = _ref.subtitle,
    title = _ref.title,
    _ref$decoration = _ref.decoration,
    decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
    footerAction = _ref.footerAction,
    panelProps = _ref.panelProps,
    panelClassName = _ref.panelClassName,
    rest = _objectWithoutProperties(_ref, _excluded);
  var titleId = (0, _services.useGeneratedHtmlId)();
  if (step === 0) {
    console.warn('EuiTourStep `step` should use 1-based indexing. Please update to eliminate 0 indexes.');
  }
  var _useState = (0, _react.useState)(null),
    _useState2 = _slicedToArray(_useState, 2),
    anchorNode = _useState2[0],
    setAnchorNode = _useState2[1];
  var _useState3 = (0, _react.useState)(),
    _useState4 = _slicedToArray(_useState3, 2),
    popoverPosition = _useState4[0],
    setPopoverPosition = _useState4[1];
  var onPositionChange = (0, _react.useCallback)(function (position) {
    setPopoverPosition(position);
  }, []);
  (0, _react.useEffect)(function () {
    if (anchor) {
      // Wait until next tick to find anchor node in case it's not already
      // in DOM requestAnimationFrame isn't used here because we don't need to
      // synchronize with repainting ticks and the updated value still
      // needs to go through a react DOM rerender which may take more than
      // 1 frame (16ms) of time.
      // TODO: It would be ideal to have some kind of intersection observer here instead
      var timeout = window.setTimeout(function () {
        setAnchorNode((0, _services.findElementBySelectorOrRef)(anchor));
      });
      return function () {
        return window.clearTimeout(timeout);
      };
    }
  }, [anchor]);
  var anchorClasses = (0, _classnames.default)('euiTourAnchor', className);
  var popoverClasses = (0, _classnames.default)('euiTour', panelClassName);
  var tourStyles = (0, _services.useEuiMemoizedStyles)(_tour.euiTourStyles);
  var beaconStyles = (0, _services.useEuiMemoizedStyles)(_tour.euiTourBeaconStyles);
  var beaconCss = [beaconStyles.euiTourBeacon, isStepOpen && beaconStyles.isOpen, popoverPosition && beaconStyles[popoverPosition]];
  var hasBeacon = decoration === 'beacon';
  var widthStyles = (0, _react.useMemo)(function () {
    return (0, _global_styling.logicalStyles)({
      minWidth: minWidth,
      maxWidth: maxWidth
    });
  }, [minWidth, maxWidth]);
  var noAnchor = !anchor && children;
  var PopoverComponent = noAnchor ? _popover.EuiPopover : _popover.EuiWrappingPopover;
  var button = noAnchor ? children : anchorNode;
  return button ? (0, _react2.jsx)(PopoverComponent, _extends({
    button: button,
    className: anchorClasses,
    anchorPosition: anchorPosition,
    closePopover: closePopover,
    isOpen: isStepOpen,
    ownFocus: false,
    panelClassName: popoverClasses,
    panelProps: _objectSpread(_objectSpread({}, panelProps), {}, {
      css: [tourStyles.euiTour, css, panelProps === null || panelProps === void 0 ? void 0 : panelProps.css]
    }),
    offset: hasBeacon ? 10 : 0,
    "aria-labelledby": titleId,
    arrowChildren: hasBeacon && (0, _react2.jsx)(_beacon.EuiBeacon, {
      css: beaconCss,
      className: "euiTour__beacon"
    }),
    onPositionChange: onPositionChange
  }, rest), (0, _react2.jsx)("div", {
    style: widthStyles
  }, (0, _react2.jsx)(_tour_header.EuiTourHeader, {
    id: titleId,
    title: title,
    subtitle: subtitle
  }), (0, _react2.jsx)("div", {
    className: "euiTour__content"
  }, content), (0, _react2.jsx)(_tour_footer.EuiTourFooter, {
    footerAction: footerAction,
    step: step,
    stepsTotal: stepsTotal,
    onFinish: onFinish
  }))) : null;
};
EuiTourStep.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any,
  /**
       * Element to which the tour step popover attaches when open
       */
  children: _propTypes.default.element,
  anchor: _propTypes.default.any,
  /**
       * Contents of the tour step popover
       */
  content: _propTypes.default.node.isRequired,
  /**
       * Step will display if set to `true`
       */
  isStepOpen: _propTypes.default.bool,
  /**
       * Change the default min width of the popover panel
       */
  minWidth: _propTypes.default.any,
  /**
       * Change the default max width of the popover panel
       */
  maxWidth: _propTypes.default.any,
  /**
       * Function to call for 'Skip tour' and 'End tour' actions
       */
  onFinish: _propTypes.default.func.isRequired,
  /**
       * The number of the step within the parent tour. 1-based indexing.
       */
  step: _propTypes.default.number.isRequired,
  /**
       * The total number of steps in the tour
       */
  stepsTotal: _propTypes.default.number.isRequired,
  /**
       * Smaller title text that appears atop each step in the tour. The subtitle gets wrapped in the appropriate heading level.
       */
  subtitle: _propTypes.default.node,
  /**
       * Larger title text specific to this step. The title gets wrapped in the appropriate heading level.
       */
  title: _propTypes.default.node.isRequired,
  /**
       * Extra visual indication of step location
       */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),
  /**
       * Accepts any `ReactNode` to replace the 'Skip tour' link in the footer.
       * Ideally, pass one button or an array of up to 2 buttons.
       */
  footerAction: _propTypes.default.oneOfType([_propTypes.default.node.isRequired, _propTypes.default.arrayOf(_propTypes.default.node.isRequired).isRequired])
};