"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScreenReaderItems = ScreenReaderItems;
const react_1 = __importDefault(require("react"));
function ScreenReaderItems({ screenReaderItems }) {
    const hasScreenReaderItems = screenReaderItems && screenReaderItems.length > 0;
    if (!hasScreenReaderItems) {
        return null;
    }
    return (react_1.default.createElement("dl", null, screenReaderItems.map((part) => (react_1.default.createElement(react_1.default.Fragment, { key: part.id || part.label },
        react_1.default.createElement("dt", null,
            part.label,
            ":"),
        react_1.default.createElement("dd", { id: part.id }, part.value))))));
}
//# sourceMappingURL=screen_reader_items.js.map