"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setFindRequestFilterScopeToActiveSpace = void 0;
var _build_space_data_filter = require("./build_space_data_filter");
var _stringify = require("../../../endpoint/utils/stringify");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Mutates the Find options provided on input to include a filter that will scope the search
 * down to only data that should be visible in active space
 * @param endpointServices
 * @param httpRequest
 * @param findOptions
 */
const setFindRequestFilterScopeToActiveSpace = async (endpointServices, httpRequest, findOptions) => {
  if (endpointServices.experimentalFeatures.endpointManagementSpaceAwarenessEnabled) {
    const logger = endpointServices.createLogger('setFindRequestFilterScopeToActiveSpace');
    logger.debug(() => `Find options prior to adjusting filter:\n${(0, _stringify.stringify)(findOptions)}`);
    const spaceVisibleDataFilter = (await (0, _build_space_data_filter.buildSpaceDataFilter)(endpointServices, httpRequest)).filter;
    if (isSingleListFindOptions(findOptions)) {
      findOptions.filter = `${spaceVisibleDataFilter}${findOptions.filter ? ` AND (${findOptions.filter})` : ''}`;
    } else {
      if (!findOptions.filter) {
        findOptions.filter = [];
      }

      // Add the filter for every list that was defined in the options
      findOptions.listId.forEach((listId, index) => {
        const userFilter = findOptions.filter[index];
        findOptions.filter[index] = `${spaceVisibleDataFilter}${userFilter ? ` AND (${userFilter})` : ''}`;
      });
    }
    logger.debug(() => `Find options updated with active space filter:\n${(0, _stringify.stringify)(findOptions)}`);
  }
};
exports.setFindRequestFilterScopeToActiveSpace = setFindRequestFilterScopeToActiveSpace;
const isSingleListFindOptions = findOptions => {
  return !Array.isArray(findOptions.listId);
};