"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsStatsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _dashboard_migration = require("../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _constants = require("../../../../../common/siem_migrations/dashboards/constants");
var _with_license = require("../../common/api/util/with_license");
var _authz = require("../../common/api/util/authz");
var _with_existing_migration_id = require("../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsStatsRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_DASHBOARD_MIGRATION_STATS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.GetDashboardMigrationStatsRequestParams)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const migrationId = req.params.migration_id;
    try {
      var _stats$items;
      const ctx = await context.resolve(['securitySolution']);
      const dashboardMigrationClient = ctx.securitySolution.siemMigrations.getDashboardsClient();
      const stats = await dashboardMigrationClient.task.getStats(migrationId);
      if (((_stats$items = stats.items) === null || _stats$items === void 0 ? void 0 : _stats$items.total) === 0) {
        return res.noContent();
      }
      return res.ok({
        body: stats
      });
    } catch (err) {
      logger.error(err);
      return res.badRequest({
        body: err.message
      });
    }
  })));
};
exports.registerSiemDashboardMigrationsStatsRoute = registerSiemDashboardMigrationsStatsRoute;