"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineDisableRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _translations = require("./translations");
var _risk_engine_privileges = require("../risk_engine_privileges");
var _audit = require("../audit");
var _audit2 = require("../../audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineDisableRoute = (router, getStartServices) => {
  router.versioned.post({
    access: 'internal',
    path: _constants.RISK_ENGINE_DISABLE_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, (0, _risk_engine_privileges.withRiskEnginePrivilegeCheck)(getStartServices, async (context, request, response) => {
    var _securitySolution$get;
    const securitySolution = await context.securitySolution;
    (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
      message: 'User attempted to disable the risk engine.',
      event: {
        action: _audit.RiskEngineAuditActions.RISK_ENGINE_DISABLE,
        category: _audit2.AUDIT_CATEGORY.DATABASE,
        type: _audit2.AUDIT_TYPE.CHANGE,
        outcome: _audit2.AUDIT_OUTCOME.UNKNOWN
      }
    });
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const [_, {
      taskManager
    }] = await getStartServices();
    const riskEngineClient = securitySolution.getRiskEngineDataClient();
    if (!taskManager) {
      var _securitySolution$get2;
      (_securitySolution$get2 = securitySolution.getAuditLogger()) === null || _securitySolution$get2 === void 0 ? void 0 : _securitySolution$get2.log({
        message: 'User attempted to disable the risk engine, but the Kibana Task Manager was unavailable',
        event: {
          action: _audit.RiskEngineAuditActions.RISK_ENGINE_DISABLE,
          category: _audit2.AUDIT_CATEGORY.DATABASE,
          type: _audit2.AUDIT_TYPE.CHANGE,
          outcome: _audit2.AUDIT_OUTCOME.FAILURE
        },
        error: {
          message: 'User attempted to disable the risk engine, but the Kibana Task Manager was unavailable'
        }
      });
      return siemResponse.error({
        statusCode: 400,
        body: _translations.TASK_MANAGER_UNAVAILABLE_ERROR
      });
    }
    try {
      await riskEngineClient.disableRiskEngine({
        taskManager
      });
      return response.ok({
        body: {
          success: true
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  }));
};
exports.riskEngineDisableRoute = riskEngineDisableRoute;