"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AUDIT_TYPE = exports.AUDIT_OUTCOME = exports.AUDIT_CATEGORY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AUDIT_TYPE = exports.AUDIT_TYPE = /*#__PURE__*/function (AUDIT_TYPE) {
  AUDIT_TYPE["CHANGE"] = "change";
  AUDIT_TYPE["DELETION"] = "deletion";
  AUDIT_TYPE["ACCESS"] = "access";
  AUDIT_TYPE["CREATION"] = "creation";
  return AUDIT_TYPE;
}({});
let AUDIT_CATEGORY = exports.AUDIT_CATEGORY = /*#__PURE__*/function (AUDIT_CATEGORY) {
  AUDIT_CATEGORY["AUTHENTICATION"] = "authentication";
  AUDIT_CATEGORY["DATABASE"] = "database";
  AUDIT_CATEGORY["WEB"] = "web";
  return AUDIT_CATEGORY;
}({});
let AUDIT_OUTCOME = exports.AUDIT_OUTCOME = /*#__PURE__*/function (AUDIT_OUTCOME) {
  AUDIT_OUTCOME["FAILURE"] = "failure";
  AUDIT_OUTCOME["SUCCESS"] = "success";
  AUDIT_OUTCOME["UNKNOWN"] = "unknown";
  return AUDIT_OUTCOME;
}({});