"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAssetCriticalityMappings = void 0;
var _asset_criticality_migration_client = require("../asset_criticality_migration_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateAssetCriticalityMappings = async ({
  auditLogger,
  logger,
  getStartServices
}) => {
  const [coreStart] = await getStartServices();
  const esClient = coreStart.elasticsearch.client.asInternalUser;
  const migrationClient = new _asset_criticality_migration_client.AssetCriticalityMigrationClient({
    esClient,
    logger,
    auditLogger
  });
  const shouldMigrateMappings = await migrationClient.isMappingsMigrationRequired();
  if (shouldMigrateMappings) {
    logger.info('Migrating Asset Criticality mappings');
    await migrationClient.migrateMappings();
  }
};
exports.updateAssetCriticalityMappings = updateAssetCriticalityMappings;