"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToQueryString = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToQueryString = params => {
  const querystring = Object.entries(params).reduce((acc, [key, value]) => {
    if (value != null) {
      acc.push(`${key}=${value}`);
    }
    return acc;
  }, []).join('&');
  return querystring ? `?${querystring}` : '';
};
exports.convertToQueryString = convertToQueryString;