"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureUsageService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _feature_keys = require("./feature_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FeatureUsageService {
  constructor() {
    (0, _defineProperty2.default)(this, "licensingPluginStart", void 0);
  }
  get notify() {
    var _this$licensingPlugin;
    return ((_this$licensingPlugin = this.licensingPluginStart) === null || _this$licensingPlugin === void 0 ? void 0 : _this$licensingPlugin.featureUsage.notifyUsage) || function () {};
  }
  setup(licensingPluginSetup) {
    Object.values(_feature_keys.FEATURE_KEYS).map(featureValue => {
      if (featureValue === _feature_keys.FEATURE_KEYS.TRUSTED_DEVICE_BY_POLICY) {
        return licensingPluginSetup.featureUsage.register(featureValue, 'enterprise');
      } else {
        return licensingPluginSetup.featureUsage.register(featureValue, 'platinum');
      }
    });
  }
  start(licensingPluginStart) {
    this.licensingPluginStart = licensingPluginStart;
  }
  notifyUsage(featureKey) {
    this.notify(_feature_keys.FEATURE_KEYS[featureKey]);
  }
  getResponseActionFeatureKey(responseAction) {
    return (0, _feature_keys.getResponseActionFeatureKey)(responseAction);
  }
}
exports.FeatureUsageService = FeatureUsageService;