"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessDraggableWithNonExistentProcess = exports.ProcessDraggable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/process_draggable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProcessDraggable = exports.ProcessDraggable = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgamePid,
  endgameProcessName,
  eventId,
  processExecutable,
  processName,
  processPid,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processName) && (0, _helpers.isNillEmptyOrNotFinite)(processExecutable) && (0, _helpers.isNillEmptyOrNotFinite)(endgameProcessName) && (0, _helpers.isNillEmptyOrNotFinite)(processPid) && (0, _helpers.isNillEmptyOrNotFinite)(endgamePid)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, !(0, _helpers.isNillEmptyOrNotFinite)(processName) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.name",
    value: processName,
    iconType: "console",
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 13
    }
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(processExecutable) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.executable",
    value: processExecutable,
    iconType: "console",
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgameProcessName) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "endgame.process_name",
    value: endgameProcessName,
    iconType: "console",
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  })) : null, !(0, _helpers.isNillEmptyOrNotFinite)(processPid) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.pid",
    queryValue: String(processPid),
    value: `(${String(processPid)})`,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  })) : !(0, _helpers.isNillEmptyOrNotFinite)(endgamePid) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "endgame.pid",
    queryValue: String(endgamePid),
    value: `(${String(endgamePid)})`,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  })) : null);
});
ProcessDraggable.displayName = 'ProcessDraggable';
const ProcessDraggableWithNonExistentProcess = exports.ProcessDraggableWithNonExistentProcess = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgamePid,
  endgameProcessName,
  eventId,
  processExecutable,
  processName,
  processPid,
  scopeId
}) => {
  if (endgamePid == null && endgameProcessName == null && processExecutable == null && processName == null && processPid == null) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.NON_EXISTENT);
  } else {
    return /*#__PURE__*/_react.default.createElement(ProcessDraggable, {
      contextId: contextId,
      endgamePid: endgamePid,
      endgameProcessName: endgameProcessName,
      eventId: eventId,
      processExecutable: processExecutable,
      processName: processName,
      processPid: processPid,
      scopeId: scopeId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 9
      }
    });
  }
});
ProcessDraggableWithNonExistentProcess.displayName = 'ProcessDraggableWithNonExistentProcess';