"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TriggerComponent = exports.Trigger = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/trigger.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TriggerComponent = ({
  activePatterns,
  disabled,
  isModified,
  isOnlyDetectionAlerts,
  isPopoverOpen,
  isTimelineSourcerer,
  loading,
  onClick,
  selectedPatterns,
  signalIndexName
}) => {
  const badge = (0, _react.useMemo)(() => {
    switch (isModified) {
      case 'modified':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          "data-test-subj": "sourcerer-modified-badge",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 11
          }
        }, i18n.MODIFIED_BADGE_TITLE);
      case 'alerts':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          "data-test-subj": "sourcerer-alerts-badge",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 11
          }
        }, i18n.ALERTS_BADGE_TITLE);
      case 'deprecated':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          color: "warning",
          "data-test-subj": "sourcerer-deprecated-badge",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 55,
            columnNumber: 11
          }
        }, i18n.DEPRECATED_BADGE_TITLE);
      case 'missingPatterns':
        return /*#__PURE__*/_react.default.createElement(_helpers.StyledBadge, {
          color: "warning",
          "data-test-subj": "sourcerer-missingPatterns-badge",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 11
          }
        }, i18n.DEPRECATED_BADGE_TITLE);
      case '':
      default:
        return null;
    }
  }, [isModified]);
  const Button = (0, _react.useMemo)(() => isTimelineSourcerer ? _eui.EuiButton : _helpers.StyledButtonEmpty, [isTimelineSourcerer]);
  const trigger = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(Button, {
    "aria-label": i18n.DATA_VIEW,
    "data-test-subj": isTimelineSourcerer ? 'timeline-sourcerer-trigger' : 'sourcerer-trigger',
    color: "primary",
    iconSide: "right",
    iconType: "arrowDown",
    disabled: disabled,
    isLoading: loading,
    onClick: onClick,
    size: "s",
    title: i18n.DATA_VIEW,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, i18n.DATA_VIEW, !disabled && badge), [disabled, badge, isTimelineSourcerer, loading, onClick, Button]);
  const tooltipContent = (0, _react.useMemo)(() => disabled ? i18n.DISABLED_SOURCERER : (0, _helpers.getTooltipContent)({
    isOnlyDetectionAlerts,
    isPopoverOpen,
    // if activePatterns, use because we are in the temporary sourcerer state
    selectedPatterns: activePatterns !== null && activePatterns !== void 0 ? activePatterns : selectedPatterns,
    signalIndexName
  }), [activePatterns, disabled, isOnlyDetectionAlerts, isPopoverOpen, selectedPatterns, signalIndexName]);
  return tooltipContent ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipContent,
    "data-test-subj": "sourcerer-tooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, trigger) : trigger;
};
exports.TriggerComponent = TriggerComponent;
const Trigger = exports.Trigger = /*#__PURE__*/(0, _react.memo)(TriggerComponent);