"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthorFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../../../types");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/filters/author.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AUTHOR_FILTER_POPOVER_WIDTH = 150;
const AuthorFilterButton = exports.AuthorFilterButton = /*#__PURE__*/_react.default.memo(({
  author,
  onAuthorChanged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = (0, _react.useMemo)(() => [{
    label: i18n.ELASTIC_AUTHOR_FILTER_OPTION,
    data: {
      author: _types.AuthorFilter.ELASTIC
    },
    checked: author === _types.AuthorFilter.ELASTIC ? 'on' : undefined
  }, {
    label: i18n.CUSTOM_AUTHOR_FILTER_OPTION,
    data: {
      author: _types.AuthorFilter.CUSTOM
    },
    checked: author === _types.AuthorFilter.CUSTOM ? 'on' : undefined
  }], [author]);
  const handleOptionsChange = (0, _react.useCallback)((_options, _event, changedOption) => {
    var _changedOption$data;
    setIsPopoverOpen(false);
    if (changedOption.checked && changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.author) {
      onAuthorChanged(changedOption.data.author);
    } else if (!changedOption.checked) {
      onAuthorChanged();
    }
  }, [onAuthorChanged]);
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    isSelected: isPopoverOpen,
    hasActiveFilters: author !== undefined,
    numActiveFilters: author ? 1 : 0,
    "data-test-subj": "authorFilterButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, i18n.AUTHOR_BUTTON_TITLE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(!isPopoverOpen);
    },
    panelPaddingSize: "none",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.AUTHOR_FILTER_ARIAL_LABEL,
    options: selectableOptions,
    onChange: handleOptionsChange,
    singleSelection: true,
    "data-test-subj": "authorFilterSelectableList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: {
      width: AUTHOR_FILTER_POPOVER_WIDTH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 22
    }
  }, list)));
});
AuthorFilterButton.displayName = 'AuthorFilterButton';