"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchemaInformation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _use_colors = require("../use_colors");
var _styles = require("../panels/styles");
var _generated_text = require("../generated_text");
var _styles2 = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/controls/schema.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchemaInformation = ({
  id,
  closePopover,
  setActivePopover,
  isOpen
}) => {
  var _sourceAndSchema$data, _sourceAndSchema$sche, _sourceAndSchema$sche2;
  const colorMap = (0, _use_colors.useColors)();
  const sourceAndSchema = (0, _reactRedux.useSelector)(state => selectors.resolverTreeSourceAndSchema(state.analyzer[id]));
  const setAsActivePopover = (0, _react.useCallback)(() => setActivePopover('schemaInfo'), [setActivePopover]);
  const schemaInfoButtonTitle = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaInfoButtonTitle', {
    defaultMessage: 'Schema Information'
  });
  const unknownSchemaValue = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.unknownSchemaValue', {
    defaultMessage: 'Unknown'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiButtonIcon, {
      "data-test-subj": "resolver:graph-controls:schema-info-button",
      size: "m",
      title: schemaInfoButtonTitle,
      "aria-label": schemaInfoButtonTitle,
      onClick: setAsActivePopover,
      iconType: "info",
      $backgroundColor: colorMap.graphControlsBackground,
      $iconColor: colorMap.graphControls,
      $borderColor: colorMap.graphControlsBorderColor,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    css: {
      textTransform: 'uppercase'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaInfoTitle', {
    defaultMessage: 'process tree'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaInfoTooltip', {
      defaultMessage: 'These are the fields used to create the process tree'
    }),
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    // Limit the width based on UX design
    css: {
      maxWidth: '268px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledDescriptionList, {
    "data-test-subj": "resolver:graph-controls:schema-info",
    type: "column",
    columnWidths: _styles2.COLUMN_WIDTH,
    align: "left",
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:schema-info:title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaSource', {
    defaultMessage: 'source'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:schema-info:description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, (_sourceAndSchema$data = sourceAndSchema === null || sourceAndSchema === void 0 ? void 0 : sourceAndSchema.dataSource) !== null && _sourceAndSchema$data !== void 0 ? _sourceAndSchema$data : unknownSchemaValue)), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:schema-info:title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaID', {
    defaultMessage: 'id'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:schema-info:description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, (_sourceAndSchema$sche = sourceAndSchema === null || sourceAndSchema === void 0 ? void 0 : sourceAndSchema.schema.id) !== null && _sourceAndSchema$sche !== void 0 ? _sourceAndSchema$sche : unknownSchemaValue)), /*#__PURE__*/_react.default.createElement(_styles2.StyledEuiDescriptionListTitle, {
    "data-test-subj": "resolver:graph-controls:schema-info:title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.schemaEdge', {
    defaultMessage: 'edge'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "resolver:graph-controls:schema-info:description",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_generated_text.GeneratedText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  }, (_sourceAndSchema$sche2 = sourceAndSchema === null || sourceAndSchema === void 0 ? void 0 : sourceAndSchema.schema.parent) !== null && _sourceAndSchema$sche2 !== void 0 ? _sourceAndSchema$sche2 : unknownSchemaValue))))));
};
exports.SchemaInformation = SchemaInformation;