"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOverviewHostStats = exports.OverviewHostStats = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _stat_value = require("../stat_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/overview_host_stats/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getOverviewHostStats = data => {
  var _data$auditbeatAuditd, _data$auditbeatFIM, _data$auditbeatLogin, _data$auditbeatPackag, _data$auditbeatProces, _data$auditbeatUser, _data$endgameDns, _data$endgameFile, _data$endgameImageLoa, _data$endgameNetwork, _data$endgameProcess, _data$endgameRegistry, _data$endgameSecurity, _data$filebeatSystemM, _data$winlogbeatSecur, _data$winlogbeatMWSys;
  return [{
    count: (_data$auditbeatAuditd = data.auditbeatAuditd) !== null && _data$auditbeatAuditd !== void 0 ? _data$auditbeatAuditd : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatAuditTitle",
      defaultMessage: "Audit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    }),
    id: 'auditbeatAuditd'
  }, {
    count: (_data$auditbeatFIM = data.auditbeatFIM) !== null && _data$auditbeatFIM !== void 0 ? _data$auditbeatFIM : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatFimTitle",
      defaultMessage: "File Integrity Module",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 7
      }
    }),
    id: 'auditbeatFIM'
  }, {
    count: (_data$auditbeatLogin = data.auditbeatLogin) !== null && _data$auditbeatLogin !== void 0 ? _data$auditbeatLogin : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatLoginTitle",
      defaultMessage: "Login",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 7
      }
    }),
    id: 'auditbeatLogin'
  }, {
    count: (_data$auditbeatPackag = data.auditbeatPackage) !== null && _data$auditbeatPackag !== void 0 ? _data$auditbeatPackag : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatPackageTitle",
      defaultMessage: "Package",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 7
      }
    }),
    id: 'auditbeatPackage'
  }, {
    count: (_data$auditbeatProces = data.auditbeatProcess) !== null && _data$auditbeatProces !== void 0 ? _data$auditbeatProces : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatProcessTitle",
      defaultMessage: "Process",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }),
    id: 'auditbeatProcess'
  }, {
    count: (_data$auditbeatUser = data.auditbeatUser) !== null && _data$auditbeatUser !== void 0 ? _data$auditbeatUser : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.auditBeatUserTitle",
      defaultMessage: "User",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }),
    id: 'auditbeatUser'
  }, {
    count: (_data$endgameDns = data.endgameDns) !== null && _data$endgameDns !== void 0 ? _data$endgameDns : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameDnsTitle",
      defaultMessage: "DNS",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }),
    id: 'endgameDns'
  }, {
    count: (_data$endgameFile = data.endgameFile) !== null && _data$endgameFile !== void 0 ? _data$endgameFile : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameFileTitle",
      defaultMessage: "File",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }),
    id: 'endgameFile'
  }, {
    count: (_data$endgameImageLoa = data.endgameImageLoad) !== null && _data$endgameImageLoa !== void 0 ? _data$endgameImageLoa : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameImageLoadTitle",
      defaultMessage: "Image Load",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }),
    id: 'endgameImageLoad'
  }, {
    count: (_data$endgameNetwork = data.endgameNetwork) !== null && _data$endgameNetwork !== void 0 ? _data$endgameNetwork : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameNetworkTitle",
      defaultMessage: "Network",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }),
    id: 'endgameNetwork'
  }, {
    count: (_data$endgameProcess = data.endgameProcess) !== null && _data$endgameProcess !== void 0 ? _data$endgameProcess : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameProcessTitle",
      defaultMessage: "Process",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 7
      }
    }),
    id: 'endgameProcess'
  }, {
    count: (_data$endgameRegistry = data.endgameRegistry) !== null && _data$endgameRegistry !== void 0 ? _data$endgameRegistry : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameRegistryTitle",
      defaultMessage: "Registry",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 7
      }
    }),
    id: 'endgameRegistry'
  }, {
    count: (_data$endgameSecurity = data.endgameSecurity) !== null && _data$endgameSecurity !== void 0 ? _data$endgameSecurity : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.endgameSecurityTitle",
      defaultMessage: "Security",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 7
      }
    }),
    id: 'endgameSecurity'
  }, {
    count: (_data$filebeatSystemM = data.filebeatSystemModule) !== null && _data$filebeatSystemM !== void 0 ? _data$filebeatSystemM : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.filebeatSystemModuleTitle",
      defaultMessage: "System Module",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 7
      }
    }),
    id: 'filebeatSystemModule'
  }, {
    count: (_data$winlogbeatSecur = data.winlogbeatSecurity) !== null && _data$winlogbeatSecur !== void 0 ? _data$winlogbeatSecur : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.winlogbeatSecurityTitle",
      defaultMessage: "Security",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }),
    id: 'winlogbeatSecurity'
  }, {
    count: (_data$winlogbeatMWSys = data.winlogbeatMWSysmonOperational) !== null && _data$winlogbeatMWSys !== void 0 ? _data$winlogbeatMWSys : 0,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.overview.winlogbeatMWSysmonOperational",
      defaultMessage: "Microsoft-Windows-Sysmon/Operational",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 7
      }
    }),
    id: 'winlogbeatMWSysmonOperational'
  }];
};
exports.getOverviewHostStats = getOverviewHostStats;
const HostStatsContainer = _styled.default.div`
  .accordion-button {
    width: 100%;
  }
`;
const hostStatGroups = [{
  groupId: 'auditbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupAuditbeat",
    defaultMessage: "Auditbeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }),
  statIds: ['auditbeatAuditd', 'auditbeatFIM', 'auditbeatLogin', 'auditbeatPackage', 'auditbeatProcess', 'auditbeatUser']
}, {
  groupId: 'endgame',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupElasticEndpointSecurity",
    defaultMessage: "Endpoint Security",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }),
  statIds: ['endgameDns', 'endgameFile', 'endgameImageLoad', 'endgameNetwork', 'endgameProcess', 'endgameRegistry', 'endgameSecurity']
}, {
  groupId: 'filebeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupFilebeat",
    defaultMessage: "Filebeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }),
  statIds: ['filebeatSystemModule']
}, {
  groupId: 'winlogbeat',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.overview.hostStatGroupWinlogbeat",
    defaultMessage: "Winlogbeat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }),
  statIds: ['winlogbeatSecurity', 'winlogbeatMWSysmonOperational']
}];
const MoveItLeftTitle = _styled.default.div`
  margin-left: 24px;
  @media only screen and (min-width: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.breakpoint.m}) {
    max-width: 40px;
  }
`;
const MoveItLeft = _styled.default.div`
  margin-left: 24px;
`;
const NoMarginTopFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  @media only screen and (max-width: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.breakpoint.m}) {
    margin-top: -10px !important;
  }
`;
const AccordionContent = _styled.default.div`
  padding-top: 8px;
`;
const OverviewHostStatsComponent = ({
  data,
  loading
}) => {
  const allHostStats = getOverviewHostStats(data);
  const allHostStatsCount = allHostStats.reduce((total, stat) => total + stat.count, 0);
  return /*#__PURE__*/_react.default.createElement(HostStatsContainer, {
    "data-test-subj": "overview-hosts-stats",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 5
    }
  }, hostStatGroups.map((statGroup, i) => {
    const statsForGroup = allHostStats.filter(s => statGroup.statIds.includes(s.id));
    const statsForGroupCount = statsForGroup.reduce((total, stat) => total + stat.count, 0);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: statGroup.groupId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `host-stat-accordion-group${statGroup.groupId}`,
      buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        justifyContent: "spaceBetween",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 283,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 284,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 285,
          columnNumber: 21
        }
      }, statGroup.name)), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
        count: statsForGroupCount,
        isGroupStat: true,
        isLoading: loading,
        max: allHostStatsCount,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 288,
          columnNumber: 21
        }
      }))),
      buttonContentClassName: "accordion-button",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(AccordionContent, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 15
      }
    }, statsForGroup.map(stat => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      key: stat.id,
      gutterSize: "s",
      justifyContent: "spaceBetween",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 302,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(MoveItLeftTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 25
      }
    }, stat.title))), /*#__PURE__*/_react.default.createElement(NoMarginTopFlexItem, {
      "data-test-subj": `host-stat-${stat.id}`,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(MoveItLeft, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 308,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_stat_value.StatValue, {
      count: stat.count,
      isGroupStat: false,
      isLoading: loading,
      max: statsForGroupCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 309,
        columnNumber: 25
      }
    }))))))));
  }));
};
const OverviewHostStats = exports.OverviewHostStats = /*#__PURE__*/_react.default.memo(OverviewHostStatsComponent);