"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStoredUrlDetails = exports.useStoredSelectedCardItemId = exports.useStoredCompletedCardIds = exports.useStoredAssistantConnectorId = void 0;
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_stored_state = require("../../../common/lib/integrations/hooks/use_stored_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LocalStorageKey = {
  videoVisited: 'securitySolution.onboarding.videoVisited',
  completeCards: 'securitySolution.onboarding.completeCards',
  expandedCard: 'securitySolution.onboarding.expandedCard',
  urlDetails: 'securitySolution.onboarding.urlDetails',
  selectedCardItemId: 'securitySolution.onboarding.selectedCardItem',
  assistantConnectorId: 'securitySolution.onboarding.assistantCard.connectorId'
};

/**
 * Stores the completed card IDs per space
 */
const useStoredCompletedCardIds = spaceId => (0, _use_stored_state.useDefinedLocalStorage)(`${LocalStorageKey.completeCards}.${spaceId}`, []);

/**
 * Stores the selected topic ID per space
 */
exports.useStoredCompletedCardIds = useStoredCompletedCardIds;
const useStoredUrlDetails = spaceId => (0, _useLocalStorage.default)(`${LocalStorageKey.urlDetails}.${spaceId}`);

/**
 * Stores the selected selectable card ID per space
 */
exports.useStoredUrlDetails = useStoredUrlDetails;
const useStoredSelectedCardItemId = (cardType, spaceId, defaultSelectedCardItemId) => (0, _use_stored_state.useDefinedLocalStorage)(`${LocalStorageKey.selectedCardItemId}.${cardType}.${spaceId}`, defaultSelectedCardItemId);

/**
 * Stores the integration search term per space
 */
exports.useStoredSelectedCardItemId = useStoredSelectedCardItemId;
const useStoredAssistantConnectorId = spaceId => (0, _use_stored_state.useDefinedLocalStorage)(`${LocalStorageKey.assistantConnectorId}.${spaceId}`, undefined);
exports.useStoredAssistantConnectorId = useStoredAssistantConnectorId;