"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointActionFailureMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _translations = require("../endpoint_response_actions_list/translations");
var _empty_value = require("../../../common/components/empty_value");
var _endpoint_action_response_codes = require("../endpoint_responder/lib/endpoint_action_response_codes");
var _key_value_display = require("../key_value_display");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/endpoint_action_failure_message/endpoint_action_failure_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyValue = (0, _empty_value.getEmptyValue)();
const ERROR_INFO_LABELS = Object.freeze({
  errors: _i18n.i18n.translate('xpack.securitySolution.endpointActionFailureMessage.errors', {
    defaultMessage: 'Errors'
  }),
  host: _i18n.i18n.translate('xpack.securitySolution.endpointActionFailureMessage.host', {
    defaultMessage: 'Host'
  })
});
// logic for determining agent host/errors info
const getAgentErrors = action => {
  const allAgentErrors = [];
  if (action.outputs || action.errors && action.errors.length) {
    for (const agent of action.agents) {
      var _action$outputs;
      const endpointAgentOutput = (_action$outputs = action.outputs) === null || _action$outputs === void 0 ? void 0 : _action$outputs[agent];
      const agentState = action.agentState[agent];
      const hasErrors = agentState && agentState.errors;
      const hasOutputCode = !!endpointAgentOutput && endpointAgentOutput.type === 'json' && !!endpointAgentOutput.content && !!endpointAgentOutput.content.code;
      const agentErrorInfo = {
        name: '',
        errors: []
      };
      if (hasOutputCode && !!endpointAgentOutput && !!_endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]) {
        agentErrorInfo.errors.push(_endpoint_action_response_codes.endpointActionResponseCodes[endpointAgentOutput.content.code]);
      }
      if (hasErrors) {
        const errorMessages = [...new Set(agentState.errors)];
        agentErrorInfo.errors.push(...errorMessages);
      }
      if (agentErrorInfo.errors.length) {
        var _action$hosts$agent;
        agentErrorInfo.name = ((_action$hosts$agent = action.hosts[agent]) === null || _action$hosts$agent === void 0 ? void 0 : _action$hosts$agent.name) || `${agent} (${_translations.UX_MESSAGES.unenrolled.host})`;
      }
      if (agentErrorInfo.errors.length) {
        allAgentErrors.push(agentErrorInfo);
      }
    }
  }
  return allAgentErrors;
};
const EndpointActionFailureMessage = exports.EndpointActionFailureMessage = /*#__PURE__*/(0, _react.memo)(({
  action,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return (0, _react.useMemo)(() => {
    if (!action.isCompleted || action.wasSuccessful) {
      return null;
    }
    const allAgentErrors = getAgentErrors(action);
    const errorCount = allAgentErrors.map(agentErrorInfo => agentErrorInfo.errors).flat().length;
    const isMultiAgentAction = errorCount && action.agents.length > 1;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": getTestId('response-action-failure-info'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointResponseActions.actionError.errorMessage",
      defaultMessage: "The following { errorCount, plural, =1 {error was} other {errors were}} encountered:",
      values: {
        errorCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !errorCount ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpointActionFailureMessage.unknownFailure",
      defaultMessage: "An unknown error occurred",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }) : isMultiAgentAction ? allAgentErrors.map(agentErrorInfo => /*#__PURE__*/_react.default.createElement("div", {
      key: agentErrorInfo.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
      name: ERROR_INFO_LABELS.host,
      value: agentErrorInfo.name.length ? agentErrorInfo.name : emptyValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_key_value_display.KeyValueDisplay, {
      name: ERROR_INFO_LABELS.errors,
      value: agentErrorInfo.errors.join(' | '),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 19
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 19
      }
    }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, allAgentErrors[0].errors.join(' | '))));
  }, [action, getTestId]);
});
EndpointActionFailureMessage.displayName = 'EndpointActionFailureMessage';