"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _flyout_history = require("./flyout_history");
var _history_utils = require("../utils/history_utils");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/shared/components/flyout_navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Navigation menu on the right panel only, with expand/collapse button and option to
 * pass in a list of actions to be displayed on top.
 */
const FlyoutNavigation = exports.FlyoutNavigation = /*#__PURE__*/(0, _react.memo)(({
  flyoutIsExpandable = false,
  expandDetails,
  actions,
  isPreviewMode,
  isRulePreview
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const history = (0, _expandableFlyout.useExpandableFlyoutHistory)();
  const isNewNavigationEnabled = !(0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newExpandableFlyoutNavigationDisabled');
  const historyArray = (0, _react.useMemo)(() => (0, _history_utils.getProcessedHistory)({
    history,
    maxCount: 10
  }), [history]);
  // Don't show history in rule preview
  const hasHistory = !isRulePreview && isNewNavigationEnabled;
  const panels = (0, _expandableFlyout.useExpandableFlyoutState)();
  const isExpanded = !!panels.left;
  const {
    closeLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutApi)();
  const collapseDetails = (0, _react.useCallback)(() => closeLeftPanel(), [closeLeftPanel]);
  const collapseButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: collapseDetails,
    iconType: "arrowEnd",
    size: "s",
    "data-test-subj": _test_ids.COLLAPSE_DETAILS_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.collapseDetailButtonAriaLabel', {
      defaultMessage: 'Collapse details'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.collapseDetailButtonLabel",
    defaultMessage: "Collapse details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })), [collapseDetails]);
  const expandButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: expandDetails,
    iconType: "arrowStart",
    size: "s",
    "data-test-subj": _test_ids.EXPAND_DETAILS_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.expandDetailButtonAriaLabel', {
      defaultMessage: 'Expand details'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.expandDetailButtonLabel",
    defaultMessage: "Expand details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  })), [expandDetails]);

  // do not show navigation in preview mode
  if (isPreviewMode) {
    return null;
  }
  return flyoutIsExpandable || actions || hasHistory ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    css: (0, _react2.css)`
            padding-left: ${euiTheme.size.s};
            padding-right: ${euiTheme.size.xxxxl};
            height: ${euiTheme.size.xxl};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, flyoutIsExpandable && expandDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
                    border-right: 1px ${euiTheme.colors.lightShade} solid;
                    padding-right: -${euiTheme.size.m};
                  `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 17
    }
  }, isExpanded ? collapseButton : expandButton), hasHistory && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_history.FlyoutHistory, {
    history: historyArray,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  })))), actions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": _test_ids.HEADER_ACTIONS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  }, actions))) : null;
});
FlyoutNavigation.displayName = 'FlyoutNavigation';