"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _managed_details = require("../../../../common/search_strategy/security_solution/users/managed_details");
var _redirect_to_users = require("../../../common/components/link_to/redirect_to_users");
var _links = require("../../../common/components/links");
var _formatted_date = require("../../../common/components/formatted_date");
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_title = require("../../shared/components/flyout_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/user_right/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const linkTitleCSS = {
  width: 'fit-content'
};
const UserPanelHeader = ({
  userName,
  observedUser,
  managedUser
}) => {
  var _managedUser$data, _managedUser$data$Man, _managedUser$data$Man2, _managedUser$data2, _managedUser$data2$Ma, _managedUser$data2$Ma2;
  const oktaTimestamp = (_managedUser$data = managedUser.data) === null || _managedUser$data === void 0 ? void 0 : (_managedUser$data$Man = _managedUser$data[_managed_details.ManagedUserDatasetKey.OKTA]) === null || _managedUser$data$Man === void 0 ? void 0 : (_managedUser$data$Man2 = _managedUser$data$Man.fields) === null || _managedUser$data$Man2 === void 0 ? void 0 : _managedUser$data$Man2['@timestamp'][0];
  const entraTimestamp = (_managedUser$data2 = managedUser.data) === null || _managedUser$data2 === void 0 ? void 0 : (_managedUser$data2$Ma = _managedUser$data2[_managed_details.ManagedUserDatasetKey.ENTRA]) === null || _managedUser$data2$Ma === void 0 ? void 0 : (_managedUser$data2$Ma2 = _managedUser$data2$Ma.fields) === null || _managedUser$data2$Ma2 === void 0 ? void 0 : _managedUser$data2$Ma2['@timestamp'][0];
  const isManaged = !!oktaTimestamp || !!entraTimestamp;
  const lastSeenDate = (0, _react.useMemo)(() => (0, _fp.max)([observedUser.lastSeen.date, entraTimestamp, oktaTimestamp].map(el => el && new Date(el))), [oktaTimestamp, entraTimestamp, observedUser.lastSeen]);
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    "data-test-subj": "user-panel-header",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": 'user-panel-header-lastSeen',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, lastSeenDate && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: lastSeenDate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 30
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.users,
    path: (0, _redirect_to_users.getUsersDetailsUrl)(userName),
    target: '_blank',
    external: false,
    css: linkTitleCSS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: userName,
    iconType: 'user',
    isLink: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  }, observedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-panel-header-observed-badge",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.user.observedBadge",
    defaultMessage: "Observed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-panel-header-managed-badge",
    color: "hollow",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.user.managedBadge",
    defaultMessage: "Managed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 19
    }
  })))))));
};
exports.UserPanelHeader = UserPanelHeader;