"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableTabSettingButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/table_tab_setting_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TABLE_TAB_SETTING_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.right.tableTabSettingButton.label', {
  defaultMessage: 'Table settings'
});
const HIGHLIGHTED_FIELDS_ONLY_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.right.tableTabSettingButton.highlightedFieldsOnlyLabel', {
  defaultMessage: 'Show highlighted fields only'
});
const HIDE_EMPTY_FIELDS_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.right.tableTabSettingButton.hideEmptyFieldsLabel', {
  defaultMessage: 'Hide empty fields'
});
const HIDE_ALERT_FIELDS_LABEL = _i18n.i18n.translate('xpack.securitySolution.flyout.documentDetails.right.tableTabSettingButton.hideAlertFieldsLabel', {
  defaultMessage: 'Hide Kibana alert fields'
});
/**
 * Settings button for the table tab.
 */
const TableTabSettingButton = ({
  tableTabState,
  setTableTabState,
  isPopoverOpen,
  setIsPopoverOpen,
  isAlert
}) => {
  const {
    showHighlightedFields,
    hideEmptyFields,
    hideAlertFields
  } = tableTabState;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onClick = (0, _react.useCallback)(() => {
    setIsPopoverOpen(!isPopoverOpen);
  }, [isPopoverOpen, setIsPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, [setIsPopoverOpen]);
  const onToggleShowHighlightedFields = (0, _react.useCallback)(() => {
    setTableTabState({
      ...tableTabState,
      showHighlightedFields: !showHighlightedFields
    });
  }, [showHighlightedFields, setTableTabState, tableTabState]);
  const onToggleHideEmptyFields = (0, _react.useCallback)(() => {
    setTableTabState({
      ...tableTabState,
      hideEmptyFields: !hideEmptyFields
    });
  }, [hideEmptyFields, setTableTabState, tableTabState]);
  const onToggleHideAlertFields = (0, _react.useCallback)(() => {
    setTableTabState({
      ...tableTabState,
      hideAlertFields: !hideAlertFields
    });
  }, [hideAlertFields, setTableTabState, tableTabState]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: TABLE_TAB_SETTING_BUTTON_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": TABLE_TAB_SETTING_BUTTON_LABEL,
      onClick: onClick,
      iconType: "gear",
      size: "m",
      css: (0, _react2.css)`
              border: 1px solid ${euiTheme.colors.backgroundLightText};
              margin-left: -5px;
            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    display: "block",
    "data-test-subj": _test_ids.TABLE_TAB_SETTING_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "flexStart",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": _test_ids.TABLE_TAB_SETTING_HIGHLIGHTED_FIELDS_ONLY_TEST_ID,
    label: HIGHLIGHTED_FIELDS_ONLY_LABEL,
    "aria-label": HIGHLIGHTED_FIELDS_ONLY_LABEL,
    checked: showHighlightedFields,
    onChange: onToggleShowHighlightedFields,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": _test_ids.TABLE_TAB_SETTING_HIDE_EMPTY_FIELDS_TEST_ID,
    label: HIDE_EMPTY_FIELDS_LABEL,
    "aria-label": HIDE_EMPTY_FIELDS_LABEL,
    checked: hideEmptyFields,
    onChange: onToggleHideEmptyFields,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  })), isAlert && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": _test_ids.TABLE_TAB_SETTING_HIDE_ALERT_FIELDS_TEST_ID,
    label: HIDE_ALERT_FIELDS_LABEL,
    "aria-label": HIDE_ALERT_FIELDS_LABEL,
    checked: hideAlertFields,
    onChange: onToggleHideAlertFields,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  })))));
};
exports.TableTabSettingButton = TableTabSettingButton;