"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelFooter = exports.FLYOUT_FOOTER_TEST_ID = exports.ASK_AI_ASSISTANT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _i18n = require("@kbn/i18n");
var _take_action_button = require("./components/take_action_button");
var _context = require("./context");
var _use_basic_data_from_details_data = require("../document_details/shared/hooks/use_basic_data_from_details_data");
var _use_assistant = require("../document_details/right/hooks/use_assistant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/ai_for_soc/footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ASK_AI_ASSISTANT = exports.ASK_AI_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.flyout.right.footer.askAIAssistant', {
  defaultMessage: 'Ask AI Assistant'
});
const FLYOUT_FOOTER_TEST_ID = exports.FLYOUT_FOOTER_TEST_ID = 'ai-for-soc-alert-flyout-footer';

/**
 * Bottom section of the flyout that contains the take action button
 */
const PanelFooter = exports.PanelFooter = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useAIForSOCDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    showAssistant,
    showAssistantOverlay
  } = (0, _use_assistant.useAssistant)({
    dataFormattedForFieldBrowser,
    isAlert
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": FLYOUT_FOOTER_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, showAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatByTitle, {
    showAssistantOverlay: showAssistantOverlay,
    text: ASK_AI_ASSISTANT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action_button.TakeActionButton, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 13
    }
  })))));
});
PanelFooter.displayName = 'PanelFooter';