"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNetworkHttpColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty_value = require("../../../../common/components/empty_value");
var _links = require("../../../../common/components/links");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers2 = require("../../../../common/components/tables/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/network_http_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getNetworkHttpColumns = tableId => [{
  name: i18n.METHOD,
  render: ({
    node: {
      methods,
      path
    }
  }) => {
    return Array.isArray(methods) && methods.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
      fieldName: 'http.request.method',
      values: methods,
      idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-methods-${path}`),
      displayCount: 3
    }) : (0, _empty_value.getEmptyTagValue)();
  }
}, {
  name: i18n.DOMAIN,
  render: ({
    node: {
      domains,
      path
    }
  }) => Array.isArray(domains) && domains.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
    values: domains,
    fieldName: 'url.domain',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-domains-${path}`)
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  field: `node.${_network.NetworkHttpFields.path}`,
  name: i18n.PATH,
  render: path => path != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [path],
    fieldName: 'url.path',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-path-${path}`)
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.STATUS,
  render: ({
    node: {
      statuses,
      path
    }
  }) => Array.isArray(statuses) && statuses.length > 0 ? (0, _helpers2.getRowItemsWithActions)({
    values: statuses,
    fieldName: 'http.response.status_code',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-statuses-${path}`),
    displayCount: 3
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.LAST_HOST,
  render: ({
    node: {
      lastHost,
      path
    }
  }) => lastHost != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [lastHost],
    fieldName: 'host.name',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-lastHost-${path}`)
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  name: i18n.LAST_SOURCE_IP,
  render: ({
    node: {
      lastSourceIp,
      path
    }
  }) => lastSourceIp != null ? (0, _helpers2.getRowItemsWithActions)({
    values: [lastSourceIp],
    fieldName: 'source.ip',
    idPrefix: (0, _helpers.escapeDataProviderId)(`${tableId}-table-lastSourceIp-${path}`),
    render: () => /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
      ip: lastSourceIp,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 27
      }
    })
  }) : (0, _empty_value.getEmptyTagValue)()
}, {
  align: 'right',
  field: `node.${_network.NetworkHttpFields.requestCount}`,
  name: i18n.REQUESTS,
  sortable: true,
  render: requestCount => {
    if (requestCount != null) {
      return (0, _numeral.default)(requestCount).format('0,000');
    } else {
      return (0, _empty_value.getEmptyTagValue)();
    }
  }
}];
exports.getNetworkHttpColumns = getNetworkHttpColumns;