"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGrantedRightsColumns = exports.buildAuthenticationsColumns = exports.buildAccountSwitchesColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _empty_value = require("../../../../../common/components/empty_value");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _user_name = require("../../../user_name");
var _helpers = require("../../../../../common/components/tables/helpers");
var _network_details = require("../../../network_details");
var _panel_keys = require("../../../../../flyout/document_details/shared/constants/panel_keys");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_user_activity/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const COLUMN_WIDTHS = {
  actions: '5%',
  '@timestamp': '20%',
  privileged_user: '15%'
};
const timestampColumn = {
  field: '@timestamp',
  truncateText: true,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.timestamp",
    defaultMessage: "Timestamp",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }),
  width: COLUMN_WIDTHS['@timestamp'],
  dataType: 'date',
  render: timestamp => {
    if (!timestamp) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
};
const getPrivilegedUserColumn = () => ({
  field: 'privileged_user',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.privilegedUser",
    defaultMessage: "Privileged user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }),
  width: COLUMN_WIDTHS.privileged_user,
  render: user => (0, _helpers.getRowItemsWithActions)({
    values: (0, _fp.isArray)(user) ? user : [user],
    fieldName: 'user.name',
    idPrefix: 'privileged-user-monitoring-privileged-user',
    render: item => /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
      userName: item,
      scopeId: _constants.SCOPE_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 25
      }
    }),
    displayCount: 1
  })
});
const getTargetUserColumn = () => ({
  field: 'target_user',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.targetUser",
    defaultMessage: "Target user",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }),
  render: user => user != null ? /*#__PURE__*/_react.default.createElement(_user_name.UserName, {
    userName: user,
    scopeId: _constants.SCOPE_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 20
    }
  }) : (0, _empty_value.getEmptyTagValue)()
});
const getIpColumn = (fieldName = 'source.ip') => ({
  field: 'host_ip',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.sourceIp",
    defaultMessage: "Source IP",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }),
  render: ips => (0, _helpers.getRowItemsWithActions)({
    values: (0, _fp.isArray)(ips) ? ips : [ips],
    fieldName: '',
    // Dirty hack to disable CellActions, remove this when CellActions support multiple fields
    idPrefix: 'privileged-user-monitoring-ip',
    render: item => /*#__PURE__*/_react.default.createElement(_network_details.NetworkDetails, {
      ip: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 25
      }
    }),
    displayCount: 1
  })
});
const getActionsColumn = openRightPanel => ({
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.actions",
    defaultMessage: "Actions",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }),
  render: record => {
    const onClick = () => {
      openRightPanel({
        id: _panel_keys.DocumentDetailsRightPanelKey,
        params: {
          id: record._id,
          indexName: record._index,
          scopeId: _constants.SCOPE_ID
        }
      });
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "expand",
      onClick: onClick,
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.preview.ariaLabel', {
        defaultMessage: 'Preview event with id {id}',
        values: {
          id: record._id
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 7
      }
    });
  },
  width: COLUMN_WIDTHS.actions
});
const buildGrantedRightsColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), getTargetUserColumn(), {
  field: 'group_name',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.grantedRight",
    defaultMessage: "Granted right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  })
}, getIpColumn('host.ip')];
exports.buildGrantedRightsColumns = buildGrantedRightsColumns;
const buildAccountSwitchesColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), {
  ...getTargetUserColumn(),
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.targetAccount",
    defaultMessage: "Target account",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  })
}, {
  field: 'group_name',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.groupName",
    defaultMessage: "Target admin group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  })
}, {
  field: 'command_process',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.commandProcess",
    defaultMessage: "Command/Process",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  })
}, getIpColumn('host.ip')];
exports.buildAccountSwitchesColumns = buildAccountSwitchesColumns;
const buildAuthenticationsColumns = openRightPanel => [getActionsColumn(openRightPanel), timestampColumn, getPrivilegedUserColumn(), {
  field: 'source',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.source",
    defaultMessage: "Source",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }),
  render: source => {
    if (!source) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return (0, _fp.capitalize)(source);
  }
}, {
  field: 'type',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.type",
    defaultMessage: "Type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }),
  render: type => {
    if (!type) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return type;
  }
},
// TODO Add the column depending on this ticket output https://github.com/elastic/security-team/issues/12713
// {
//   field: 'method',
//   name: (
//     <FormattedMessage
//       id="xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.method"
//       defaultMessage="Method"
//     />
//   ),
//   render: (method: string) => {
//     // TODO: Implement method rendering logic
//     return '// TODO';
//   },
// },
{
  field: 'result',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.result",
    defaultMessage: "Result",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }),
  render: result => {
    if (!result) {
      return (0, _empty_value.getEmptyTagValue)();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: getResultColor(result),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 14
      }
    }, (0, _fp.capitalize)(result));
  }
}, getIpColumn(), {
  field: 'destination',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.userActivity.columns.destination",
    defaultMessage: "Destination",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  })
}];
exports.buildAuthenticationsColumns = buildAuthenticationsColumns;
const getResultColor = value => {
  const valueLowerCase = value.toLocaleLowerCase();
  if (valueLowerCase === 'success') {
    return 'success';
  }
  if (valueLowerCase === 'failure') {
    return 'danger';
  }
  return 'default';
};