"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTIONS_HISTOGRAM_ID = exports.AlertsHistogramPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _uuid = require("uuid");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _use_global_time = require("../../../../common/containers/use_global_time");
var _constants = require("../../../../../common/constants");
var _header_section = require("../../../../common/components/header_section");
var _link_to = require("../../../../common/components/link_to");
var _kibana = require("../../../../common/lib/kibana");
var _helpers = require("./helpers");
var _translations = _interopRequireWildcard(require("./translations"));
var i18n = _translations;
var _links = require("../../../../common/components/links");
var _types = require("../../../../app/types");
var _config = require("../common/config");
var _components = require("../common/components");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _translations2 = require("../common/translations");
var _alerts_histogram = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_histogram");
var _model = require("../../../../sourcerer/store/model");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _use_visualization_response = require("../../../../common/components/visualization_actions/use_visualization_response");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_histogram_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTIONS_HISTOGRAM_ID = exports.DETECTIONS_HISTOGRAM_ID = 'detections-histogram';
const ViewAlertsFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeL};
`;
const CHART_HEIGHT = 155; // px

const AlertsHistogramPanel = exports.AlertsHistogramPanel = /*#__PURE__*/(0, _react.memo)(({
  alignHeader,
  chartHeight = CHART_HEIGHT,
  comboboxRef,
  defaultStackByOption = _config.DEFAULT_STACK_BY_FIELD,
  extraActions,
  filters,
  headerChildren,
  inspectTitle,
  onFieldSelected,
  onlyField,
  paddingSize = 'm',
  panelHeight = _config.PANEL_HEIGHT,
  setComboboxInputRef,
  showGroupByPlaceholder = false,
  showLinkToAlerts = false,
  showStackBy = true,
  showTotalAlertsCount = false,
  stackByLabel,
  stackByWidth,
  title = i18n.HISTOGRAM_HEADER,
  titleSize = 'm',
  hideQueryToggle = false,
  isExpanded,
  setIsExpanded,
  signalIndexName
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();

  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_HISTOGRAM_ID}-${(0, _uuid.v4)()}`, []);
  const visualizationId = `alerts-trend-embeddable-${uniqueQueryId}`;
  const [isInitialLoading, setIsInitialLoading] = (0, _react.useState)(true);
  const [selectedStackByOption, setSelectedStackByOption] = (0, _react.useState)(onlyField == null ? defaultStackByOption : onlyField);
  const onSelect = (0, _react.useCallback)(field => {
    setSelectedStackByOption(field);
    if (onFieldSelected != null) {
      onFieldSelected(field);
    }
  }, [onFieldSelected]);
  (0, _react.useEffect)(() => {
    setSelectedStackByOption(onlyField == null ? defaultStackByOption : onlyField);
  }, [defaultStackByOption, onlyField]);
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTIONS_HISTOGRAM_ID);

  // alerts page uses isExpanded from kpi panel
  // rules detail page and overview uses the toggle query
  const toggleQuery = (0, _react.useCallback)(newToggleStatus => setIsExpanded ? setIsExpanded(newToggleStatus) : setToggleStatus(newToggleStatus), [setToggleStatus, setIsExpanded]);
  const showHistogram = (0, _react.useMemo)(() => setIsExpanded ? Boolean(isExpanded) : toggleStatus, [setIsExpanded, isExpanded, toggleStatus]);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const kibana = (0, _kibana.useKibana)();
  const {
    navigateToApp
  } = kibana.services.application;
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.alerts);
  const {
    tables,
    loading: isLoadingAlerts
  } = (0, _use_visualization_response.useVisualizationResponse)({
    visualizationId
  });
  const totalTableCount = tables && tables.meta.statistics.totalCount;
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const totalAlerts = (0, _react.useMemo)(() => {
    const visualizationAlertsCount = totalTableCount !== null && totalTableCount !== void 0 ? totalTableCount : 0;
    return (0, _translations.SHOWING_ALERTS)((0, _numeral.default)(visualizationAlertsCount).format(defaultNumberFormat), visualizationAlertsCount, '');
  }, [defaultNumberFormat, totalTableCount]);
  const goToDetectionEngine = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.alerts,
      path: (0, _link_to.getDetectionEngineUrl)(urlSearch)
    });
  }, [navigateToApp, urlSearch]);
  (0, _react.useEffect)(() => {
    let canceled = false;
    if (!canceled && !(0, _helpers.showInitialLoadingSpinner)({
      isInitialLoading,
      isLoadingAlerts
    })) {
      setIsInitialLoading(false);
    }
    return () => {
      canceled = true; // prevent long running data fetches from updating state after unmounting
    };
  }, [isInitialLoading, isLoadingAlerts, setIsInitialLoading, tables]);
  const linkButton = (0, _react.useMemo)(() => {
    if (showLinkToAlerts) {
      return /*#__PURE__*/_react.default.createElement(ViewAlertsFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 199,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
        "data-test-subj": "alerts-histogram-panel-go-to-alerts-page",
        onClick: goToDetectionEngine,
        href: formatUrl((0, _link_to.getDetectionEngineUrl)()),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 13
        }
      }, i18n.VIEW_ALERTS));
    }
  }, [showLinkToAlerts, goToDetectionEngine, formatUrl]);
  const titleText = (0, _react.useMemo)(() => onlyField == null ? title : i18n.TOP(onlyField), [onlyField, title]);
  const embeddedDataAvailable = totalTableCount != null && totalTableCount > 0;
  const subtitle = showHistogram ? (0, _helpers.createEmbeddedDataSubtitle)(embeddedDataAvailable, totalAlerts) : (0, _helpers.createGenericSubtitle)(isInitialLoading, showTotalAlertsCount, totalAlerts);
  return /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    height: panelHeight,
    hasBorder: true,
    paddingSize: paddingSize,
    "data-test-subj": "alerts-histogram-panel",
    $toggleStatus: showHistogram,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "column",
    title: titleText,
    titleSize: titleSize,
    toggleStatus: showHistogram,
    toggleQuery: hideQueryToggle ? undefined : toggleQuery,
    showInspectButton: false,
    subtitle: subtitle,
    isInspectDisabled: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    "data-test-subj": "panelFlexGroup",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 13
    }
  }, showStackBy && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
    "data-test-subj": "stackByComboBox",
    inputRef: setComboboxInputRef,
    onSelect: onSelect,
    prepend: stackByLabel,
    ref: comboboxRef,
    selected: selectedStackByOption,
    useLensCompatibleFields: true,
    width: stackByWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 19
    }
  }), showGroupByPlaceholder && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "placeholderSpacer",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "placeholderTooltip",
    content: i18n.NOT_AVAILABLE_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_components.StackByComboBox, {
    "data-test-subj": "stackByPlaceholder",
    isDisabled: true,
    onSelect: _fp.noop,
    prepend: _translations2.GROUP_BY_TOP_LABEL,
    selected: "",
    useLensCompatibleFields: true,
    width: stackByWidth,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 25
    }
  })))), headerChildren != null && headerChildren), linkButton)), showHistogram ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    signalIndexName: signalIndexName,
    "data-test-subj": "embeddable-matrix-histogram",
    extraActions: extraActions,
    extraOptions: {
      filters
    },
    getLensAttributes: _alerts_histogram.getAlertsHistogramLensAttributes,
    height: chartHeight !== null && chartHeight !== void 0 ? chartHeight : CHART_HEIGHT,
    id: visualizationId,
    inspectTitle: inspectTitle !== null && inspectTitle !== void 0 ? inspectTitle : title,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: selectedStackByOption,
    timerange: timerange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 11
    }
  }) : null);
});
AlertsHistogramPanel.displayName = 'AlertsHistogramPanel';