"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldNameField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _v8100_process = _interopRequireDefault(require("./v.8.10.0_process.json"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_response_actions/endpoint/field_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ECSSchemaOptions = _v8100_process.default.map(ecs => ({
  label: ecs.field,
  value: ecs
}));
const SINGLE_SELECTION = Object.freeze({
  asPlainText: true
});
const FIELD_LABEL = 'Custom field name';
const REQUIRED_ERROR = _i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.validations.fieldNameIsRequiredErrorMessage', {
  defaultMessage: '{field} selection is required when the process.pid toggle is disabled.',
  values: {
    field: FIELD_LABEL
  }
});
const FieldNameFieldComponent = ({
  path,
  disabled,
  readDefaultValueOnForm,
  isRequired
}) => {
  const [data] = (0, _hook_form_lib.useFormData)();
  const fieldValue = (0, _lodash.get)(data, path);
  const context = (0, _hook_form_lib.useFormContext)();
  const currentFieldNameField = context.getFields()[path];
  (0, _react.useEffect)(() => {
    // hackish way to clear errors on this field - because we base this validation on the value of overwrite toggle
    if (currentFieldNameField && !isRequired) {
      currentFieldNameField === null || currentFieldNameField === void 0 ? void 0 : currentFieldNameField.clearErrors();
    }

    // if the field is required and the value is empty, set an error, but don't do that before first validation (thus isValidated check)
    if (currentFieldNameField !== null && currentFieldNameField !== void 0 && currentFieldNameField.isValidated && !(currentFieldNameField !== null && currentFieldNameField !== void 0 && currentFieldNameField.value) && isRequired) {
      currentFieldNameField === null || currentFieldNameField === void 0 ? void 0 : currentFieldNameField.setErrors([{
        message: REQUIRED_ERROR
      }]);
    }
  }, [currentFieldNameField, isRequired]);
  const renderEntityIdNote = (0, _react.useMemo)(() => {
    const contains = fieldValue === null || fieldValue === void 0 ? void 0 : fieldValue.includes('entity_id');
    if (contains) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.responseActions.endpoint.entityIdDescription",
        defaultMessage: "Entity_id is an Elastic Defend agent specific field, if the alert does not come from Elastic Defend agent we will not be able to send the action.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responseActions.endpoint.fieldDescription",
      defaultMessage: "Choose a different alert field to identify the process to terminate.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 7
      }
    });
  }, [fieldValue]);
  const CONFIG = (0, _react.useMemo)(() => {
    return {
      label: FIELD_LABEL,
      helpText: renderEntityIdNote,
      validations: [{
        validator: ({
          value
        }) => {
          if (isRequired && value === '') {
            return {
              code: 'ERR_FIELD_MISSING',
              path,
              message: REQUIRED_ERROR
            };
          }
        }
      }]
    };
  }, [isRequired, path, renderEntityIdNote]);
  const optionsAsComboBoxOptions = (0, _react.useMemo)(() => {
    return ECSSchemaOptions.map(({
      label
    }) => ({
      label,
      value: label
    }));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: path,
    readDefaultValueOnForm: readDefaultValueOnForm,
    config: CONFIG,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, field => {
    const {
      value,
      setValue
    } = field;
    const {
      isInvalid,
      errorMessage
    } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(field);
    const valueInList = !!optionsAsComboBoxOptions.find(option => option.label === value);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: field.label,
      helpText: field.helpText,
      fullWidth: true,
      error: errorMessage,
      isInvalid: isInvalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      isInvalid: isInvalid,
      isDisabled: disabled || !isRequired,
      singleSelection: SINGLE_SELECTION,
      noSuggestions: false,
      options: optionsAsComboBoxOptions,
      fullWidth: true,
      selectedOptions: value && valueInList ? [{
        value,
        label: value
      }] : undefined,
      onChange: newValue => {
        if (newValue.length === 0) {
          setValue('');
        } else {
          setValue(newValue[0].label);
        }
      },
      "data-test-subj": "config-custom-field-name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }));
};
const FieldNameField = exports.FieldNameField = /*#__PURE__*/_react.default.memo(FieldNameFieldComponent);