"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEndpointHostIsolated = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given an endpoint host metadata record (`HostMetadata`), this utility will validate if
 * that host is isolated
 * @param endpointMetadata
 */
const isEndpointHostIsolated = endpointMetadata => {
  var _endpointMetadata$End;
  return Boolean((_endpointMetadata$End = endpointMetadata.Endpoint.state) === null || _endpointMetadata$End === void 0 ? void 0 : _endpointMetadata$End.isolation);
};
exports.isEndpointHostIsolated = isEndpointHostIsolated;