"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeMapStateToProps = exports.formatDate = exports.dispatchUpdateReduxTime = exports.connector = exports.SuperDatePickerComponent = exports.SuperDatePicker = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _helpers = require("../../store/inputs/helpers");
var _constants = require("../../../../common/constants");
var _store = require("../../../timelines/store");
var _kibana = require("../../lib/kibana");
var _actions = require("../../store/actions");
var _constants2 = require("../../store/inputs/constants");
var _selectors = require("./selectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/super_date_picker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const refreshButtonProps = {
  fill: false
};
const MAX_RECENTLY_USED_RANGES = 9;
const refetchQuery = newQueries => {
  newQueries.forEach(q => q.refetch && q.refetch());
};
const SuperDatePickerComponent = exports.SuperDatePickerComponent = /*#__PURE__*/_react.default.memo(({
  duration,
  end,
  fromStr,
  id,
  isLoading,
  kqlQuery,
  policy,
  queries,
  setDuration,
  showUpdateButton = true,
  start,
  startAutoReload,
  stopAutoReload,
  timelineId,
  toStr,
  updateReduxTime,
  disabled,
  width = 'restricted',
  compressed = false
}) => {
  const [recentlyUsedRanges, setRecentlyUsedRanges] = (0, _react.useState)([]);
  const onRefresh = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd
  }) => {
    const isQuickSelection = newStart.includes('now') || newEnd.includes('now');
    const {
      kqlHaveBeenUpdated
    } = updateReduxTime({
      end: newEnd,
      id,
      isInvalid: false,
      isQuickSelection,
      kql: kqlQuery,
      start: newStart,
      timelineId,
      hasRangeChanged: false
    });
    const currentStart = formatDate(newStart);
    const currentEnd = isQuickSelection ? formatDate(newEnd, {
      roundUp: true
    }) : formatDate(newEnd);
    if (queries && !kqlHaveBeenUpdated && (!isQuickSelection || start === currentStart && end === currentEnd)) {
      refetchQuery(queries);
    }
  }, [end, id, kqlQuery, queries, start, timelineId, updateReduxTime]);
  const onRefreshChange = (0, _react.useCallback)(({
    isPaused,
    refreshInterval
  }) => {
    const isQuickSelection = fromStr != null && fromStr.includes('now') || toStr != null && toStr.includes('now');
    if (duration !== refreshInterval) {
      setDuration({
        id,
        duration: refreshInterval
      });
    }
    if (isPaused && policy === 'interval') {
      stopAutoReload({
        id
      });
    } else if (!isPaused && policy === 'manual') {
      startAutoReload({
        id
      });
    }
    if (queries && !isPaused && (!isQuickSelection || isQuickSelection && toStr !== 'now')) {
      refetchQuery(queries);
    }
  }, [fromStr, toStr, duration, policy, setDuration, id, stopAutoReload, startAutoReload, queries]);
  const onTimeChange = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd,
    isInvalid
  }) => {
    const isQuickSelection = newStart.includes('now') || newEnd.includes('now');
    if (!isInvalid) {
      updateReduxTime({
        end: newEnd,
        id,
        isInvalid,
        isQuickSelection,
        kql: kqlQuery,
        start: newStart,
        timelineId,
        hasRangeChanged: true
      });
      const newRecentlyUsedRanges = [{
        start: newStart,
        end: newEnd
      }, ...(0, _fp.take)(MAX_RECENTLY_USED_RANGES, recentlyUsedRanges.filter(recentlyUsedRange => !(recentlyUsedRange.start === newStart && recentlyUsedRange.end === newEnd)))];
      setRecentlyUsedRanges(newRecentlyUsedRanges);
    }
  }, [updateReduxTime, id, kqlQuery, timelineId, recentlyUsedRanges]);
  const endDate = toStr != null ? toStr : new Date(end).toISOString();
  const startDate = fromStr != null ? fromStr : new Date(start).toISOString();
  const [quickRanges] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES);
  const [dateFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_DATE_FORMAT);
  const commonlyUsedRanges = (0, _fp.isEmpty)(quickRanges) ? [] : quickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    commonlyUsedRanges: commonlyUsedRanges,
    end: endDate,
    isLoading: isLoading,
    isPaused: policy === 'manual',
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    recentlyUsedRanges: recentlyUsedRanges,
    refreshInterval: duration,
    showUpdateButton: showUpdateButton,
    start: startDate,
    isDisabled: disabled,
    width: width,
    compressed: compressed,
    updateButtonProps: refreshButtonProps,
    dateFormat: dateFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 7
    }
  });
}, (prevProps, nextProps) => prevProps.duration === nextProps.duration && prevProps.end === nextProps.end && prevProps.fromStr === nextProps.fromStr && prevProps.id === nextProps.id && prevProps.isLoading === nextProps.isLoading && prevProps.policy === nextProps.policy && prevProps.setDuration === nextProps.setDuration && prevProps.start === nextProps.start && prevProps.startAutoReload === nextProps.startAutoReload && prevProps.stopAutoReload === nextProps.stopAutoReload && prevProps.timelineId === nextProps.timelineId && prevProps.disabled === nextProps.disabled && prevProps.toStr === nextProps.toStr && prevProps.updateReduxTime === nextProps.updateReduxTime && (0, _fastDeepEqual.default)(prevProps.kqlQuery, nextProps.kqlQuery) && (0, _fastDeepEqual.default)(prevProps.queries, nextProps.queries));
const formatDate = (date, options) => {
  const momentDate = _datemath.default.parse(date, options);
  return momentDate != null && momentDate.isValid() ? momentDate.toISOString() : '';
};
exports.formatDate = formatDate;
const dispatchUpdateReduxTime = dispatch => ({
  end,
  id,
  isQuickSelection,
  kql,
  start,
  timelineId,
  hasRangeChanged
}) => {
  const fromDate = formatDate(start);
  let toDate = formatDate(end, {
    roundUp: true
  });
  if (isQuickSelection) {
    if (end === start) {
      dispatch(_actions.inputsActions.setAbsoluteRangeDatePicker({
        id,
        fromStr: start,
        toStr: end,
        from: fromDate,
        to: toDate
      }));
    } else {
      dispatch(_actions.inputsActions.setRelativeRangeDatePicker({
        id,
        fromStr: start,
        toStr: end,
        from: fromDate,
        to: toDate
      }));
    }
  } else {
    toDate = formatDate(end);
    dispatch(_actions.inputsActions.setAbsoluteRangeDatePicker({
      id,
      from: formatDate(start),
      to: formatDate(end)
    }));
  }
  if (timelineId != null && hasRangeChanged) {
    dispatch(_store.timelineActions.updateRange({
      id: timelineId,
      start: fromDate,
      end: toDate
    }));
  }
  if (kql && kql.refetch) {
    var _kql$refetch;
    return {
      kqlHaveBeenUpdated: (_kql$refetch = kql.refetch(dispatch)) !== null && _kql$refetch !== void 0 ? _kql$refetch : false
    };
  }
  return {
    kqlHaveBeenUpdated: false
  };
};
exports.dispatchUpdateReduxTime = dispatchUpdateReduxTime;
const makeMapStateToProps = () => {
  const getDurationSelector = (0, _selectors.durationSelector)();
  const getEndSelector = (0, _selectors.endSelector)();
  const getFromStrSelector = (0, _selectors.fromStrSelector)();
  const getIsLoadingSelector = (0, _selectors.isLoadingSelector)();
  const getKindSelector = (0, _selectors.kindSelector)();
  const getKqlQuerySelector = (0, _selectors.kqlQuerySelector)();
  const getPolicySelector = (0, _selectors.policySelector)();
  const getQueriesSelector = (0, _selectors.queriesSelector)();
  const getStartSelector = (0, _selectors.startSelector)();
  const getToStrSelector = (0, _selectors.toStrSelector)();
  return (state, {
    id
  }) => {
    const inputsRange = (0, _fp.getOr)({}, `inputs.${id}`, state);
    return {
      duration: getDurationSelector(inputsRange),
      end: getEndSelector(inputsRange),
      fromStr: getFromStrSelector(inputsRange),
      kind: getKindSelector(inputsRange),
      policy: getPolicySelector(inputsRange),
      start: getStartSelector(inputsRange),
      toStr: getToStrSelector(inputsRange),
      isLoading: false,
      ...((0, _helpers.isQueryInput)(inputsRange) && (id === _constants2.InputsModelId.timeline || id === _constants2.InputsModelId.global) && {
        isLoading: getIsLoadingSelector(inputsRange),
        kqlQuery: getKqlQuerySelector(inputsRange),
        queries: getQueriesSelector(state, id)
      })
    };
  };
};
exports.makeMapStateToProps = makeMapStateToProps;
SuperDatePickerComponent.displayName = 'SuperDatePickerComponent';
const mapDispatchToProps = dispatch => ({
  startAutoReload: ({
    id
  }) => dispatch(_actions.inputsActions.startAutoReload({
    id
  })),
  stopAutoReload: ({
    id
  }) => dispatch(_actions.inputsActions.stopAutoReload({
    id
  })),
  setDuration: ({
    id,
    duration
  }) => dispatch(_actions.inputsActions.setDuration({
    id,
    duration
  })),
  updateReduxTime: dispatchUpdateReduxTime(dispatch)
});
const connector = exports.connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const SuperDatePicker = exports.SuperDatePicker = connector(SuperDatePickerComponent);