"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withSecuritySolutionLink = exports.useSecuritySolutionLinkProps = exports.useGetSecuritySolutionLinkProps = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _links = require("@kbn/security-solution-navigation/links");
var _use_url_state_query_params = require("../navigation/use_url_state_query_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/links/link_props.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * It returns a function to get the `onClick` and `href` props to use in link components
 * based on the` deepLinkId` and `path` parameters.
 */
const useGetSecuritySolutionLinkProps = () => {
  const getLinkProps = (0, _links.useGetLinkProps)();
  const getUrlStateQueryParams = (0, _use_url_state_query_params.useGetUrlStateQueryParams)();
  const getSecuritySolutionLinkProps = (0, _react.useCallback)(({
    deepLinkId,
    path,
    onClick
  }) => {
    const urlState = getUrlStateQueryParams(deepLinkId);
    return getLinkProps({
      id: deepLinkId,
      path,
      urlState,
      onClick
    });
  }, [getLinkProps, getUrlStateQueryParams]);
  return getSecuritySolutionLinkProps;
};

/**
 * It returns the `onClick` and `href` props to use in link components
 * based on the` deepLinkId` and `path` parameters.
 */
exports.useGetSecuritySolutionLinkProps = useGetSecuritySolutionLinkProps;
const useSecuritySolutionLinkProps = ({
  deepLinkId,
  path,
  onClick
}) => {
  const getSecuritySolutionLinkProps = useGetSecuritySolutionLinkProps();
  const securitySolutionLinkProps = (0, _react.useMemo)(() => getSecuritySolutionLinkProps({
    deepLinkId,
    path,
    onClick
  }), [getSecuritySolutionLinkProps, deepLinkId, path, onClick]);
  return securitySolutionLinkProps;
};
exports.useSecuritySolutionLinkProps = useSecuritySolutionLinkProps;
const withSecuritySolutionLinkProps = WrappedComponent => /*#__PURE__*/_react.default.memo(function WithSecuritySolutionProps({
  deepLinkId,
  ...rest
}) {
  const getUrlStateQueryParams = (0, _use_url_state_query_params.useGetUrlStateQueryParams)();
  const urlState = getUrlStateQueryParams(deepLinkId);
  return /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({
    id: deepLinkId,
    urlState
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 12
    }
  }));
});

/**
 * HOC that wraps any Link component and makes it a Security solutions internal navigation Link.
 */
const withSecuritySolutionLink = WrappedComponent => withSecuritySolutionLinkProps((0, _links.withLink)(WrappedComponent));
exports.withSecuritySolutionLink = withSecuritySolutionLink;