"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTableColumns = exports.AlertCountByRuleByStatus = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _constants = require("../../../../common/constants");
var _use_navigate_to_timeline = require("../../../overview/components/detection_response/hooks/use_navigate_to_timeline");
var _constants2 = require("../../../timelines/components/timeline/body/renderers/constants");
var _query_toggle = require("../../containers/query_toggle");
var _formatted_number = require("../formatted_number");
var _header_section = require("../header_section");
var _hover_visibility_container = require("../hover_visibility_container");
var _inspect = require("../inspect");
var _last_updated_at = require("../last_updated_at");
var _links = require("../links");
var _local_storage = require("../local_storage");
var _components = require("./components");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_alert_count_by_rule_by_status = require("./use_alert_count_by_rule_by_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/alert_count_by_status/alert_count_by_rule_by_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const STATUSES = ['open', 'acknowledged', 'closed'];
const ALERT_COUNT_BY_RULE_BY_STATUS = 'alerts-by-status-by-rule';
const LOCAL_STORAGE_KEY = 'alertCountByFieldNameWidgetSettings';
const StyledEuiPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  display: flex;
  flex-direction: column;
  position: relative;
  overflow: hidden;
  max-height: 308px;
`;
const AlertCountByRuleByStatus = exports.AlertCountByRuleByStatus = /*#__PURE__*/_react.default.memo(({
  entityFilter,
  signalIndexName,
  additionalFilters
}) => {
  const {
    field,
    value
  } = entityFilter;
  const queryId = `${ALERT_COUNT_BY_RULE_BY_STATUS}-by-${field}`;
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(queryId);
  const {
    openTimelineWithFilters
  } = (0, _use_navigate_to_timeline.useNavigateToTimeline)();
  const [selectedStatusesByField, setSelectedStatusesByField] = (0, _local_storage.useLocalStorage)({
    defaultValue: {
      [field]: ['open']
    },
    key: LOCAL_STORAGE_KEY,
    isInvalidDefault: valueFromStorage => {
      return !valueFromStorage;
    }
  });
  const columns = (0, _react.useMemo)(() => {
    return getTableColumns(ruleName => {
      const timelineFilters = [];
      for (const status of selectedStatusesByField[field]) {
        timelineFilters.push([entityFilter, {
          field: _constants2.SIGNAL_RULE_NAME_FIELD_NAME,
          value: ruleName
        }, {
          field: _constants2.SIGNAL_STATUS_FIELD_NAME,
          value: status
        }]);
      }
      openTimelineWithFilters(timelineFilters);
    });
  }, [entityFilter, field, openTimelineWithFilters, selectedStatusesByField]);
  const updateSelection = (0, _react.useCallback)(selection => {
    setSelectedStatusesByField({
      ...selectedStatusesByField,
      [field]: selection
    });
  }, [field, selectedStatusesByField, setSelectedStatusesByField]);
  const {
    items,
    isLoading,
    updatedAt
  } = (0, _use_alert_count_by_rule_by_status.useAlertCountByRuleByStatus)({
    additionalFilters,
    field,
    value,
    queryId,
    statuses: selectedStatusesByField[field],
    skip: !toggleStatus,
    signalIndexName
  });
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StyledEuiPanel, {
    hasBorder: true,
    "data-test-subj": "alertCountByRulePanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: queryId,
    title: i18n.ALERTS_BY_RULE,
    titleSize: "m",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 25
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.MultiSelectPopover, {
    title: i18n.Status,
    allItems: STATUSES,
    selectedItems: selectedStatusesByField[field] || ['open'],
    onSelectedItemsChange: selectedItems => updateSelection(selectedItems),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 15
    }
  })), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: "eui-yScroll",
    "data-test-subj": "alertCountByRuleTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 44
        }
      }, i18n.NO_ALERTS_FOUND),
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 17
    }
  })))));
});
AlertCountByRuleByStatus.displayName = 'AlertCountByStatus';
const getTableColumns = openRuleInTimelineWithAdditionalFields => [{
  field: 'ruleName',
  name: i18n.COLUMN_HEADER_RULE_NAME,
  'data-test-subj': i18n.COLUMN_HEADER_RULE_NAME,
  align: 'left',
  width: '67%',
  sortable: false,
  render: (ruleName, {
    uuid
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": `${ruleName}-tooltip`,
    title: i18n.TOOLTIP_TITLE,
    content: ruleName,
    anchorClassName: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    "data-test-subj": "severityRuleAlertsTable-name",
    deepLinkId: _constants.SecurityPageName.rules,
    path: `id/${uuid}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, ruleName))
}, {
  field: 'count',
  name: i18n.COLUMN_HEADER_COUNT,
  width: '33%',
  'data-test-subj': i18n.COLUMN_HEADER_COUNT,
  sortable: true,
  align: 'right',
  render: (count, {
    ruleName
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: count === 0,
    onClick: async () => {
      await openRuleInTimelineWithAdditionalFields(ruleName);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
    count: count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }))
}];
exports.getTableColumns = getTableColumns;