"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var i18n = _interopRequireWildcard(require("./translations"));
var _edit_form = require("./edit_form");
var _helpers = require("../../../helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/edit_form/use_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const defaultInitialValue = {
  name: '',
  alertsSelectionSettings: {
    query: (0, _helpers.getDefaultQuery)(),
    filters: [],
    size: _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS,
    start: _elasticAssistantCommon.DEFAULT_START,
    end: _elasticAssistantCommon.DEFAULT_END
  },
  interval: '24h',
  actions: []
};
const useEditForm = props => {
  const {
    initialValue = defaultInitialValue,
    isLoading,
    onFormMutated,
    onSave,
    saveButtonTitle
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [formState, setFormState] = (0, _react.useState)({
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: defaultInitialValue
    }),
    value: initialValue
  });
  const onCreate = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data
    } = await formState.submit();
    if (!isValid) {
      return;
    }
    onSave === null || onSave === void 0 ? void 0 : onSave(data);
  }, [formState, onSave]);
  const editForm = (0, _react.useMemo)(() => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
        isLoading: isLoading,
        loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 86,
            columnNumber: 15
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 87,
            columnNumber: 15
          }
        })),
        loadedContent: null,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_edit_form.EditForm, {
      initialValue: initialValue,
      onChange: setFormState,
      onFormMutated: onFormMutated,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    });
  }, [initialValue, isLoading, onFormMutated]);
  const actionButtons = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: (0, _react2.css)`
            margin-right: ${euiTheme.size.s};
          `,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "save",
      size: "m",
      onClick: onCreate,
      disabled: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, saveButtonTitle !== null && saveButtonTitle !== void 0 ? saveButtonTitle : i18n.SCHEDULE_SAVE_BUTTON_TITLE))));
  }, [euiTheme.size.s, isLoading, onCreate, saveButtonTitle]);
  return {
    editForm,
    actionButtons
  };
};
exports.useEditForm = useEditForm;