"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.indexDeviceEvents = void 0;
var _usage_tracker = require("./usage_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function delay(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
const indexDeviceEvents = exports.indexDeviceEvents = _usage_tracker.usageTracker.track('indexDeviceEvents', async ({
  client,
  deviceIndex,
  generator,
  numDeviceEvents,
  options = {}
}) => {
  const deviceEventsGenerator = generator.deviceEventsGenerator(numDeviceEvents, options.eventsDataStream);
  let result = deviceEventsGenerator.next();
  const deviceEventDocs = [];
  while (!result.done) {
    deviceEventDocs.push(result.value);
    result = deviceEventsGenerator.next();
  }
  if (deviceEventDocs.length > 0) {
    const body = deviceEventDocs.flatMap(doc => [{
      create: {
        _index: deviceIndex
      }
    }, doc]);
    await client.bulk({
      body,
      refresh: 'wait_for'
    });
  }
  await client.indices.refresh({
    index: deviceIndex
  });
  await delay(5000);
});