"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterPrivileges = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _remote_cluster_privileges_form = require("./remote_cluster_privileges_form");
var _model = require("../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763121847558429896/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/remote_cluster_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RemoteClusterPrivileges = ({
  remoteClusters,
  license,
  availableRemoteClusterPrivileges,
  role,
  editable,
  onChange,
  validator
}) => {
  const remoteClusterPrivileges = (0, _react.useMemo)(() => {
    var _role$elasticsearch$r;
    return (_role$elasticsearch$r = role.elasticsearch.remote_cluster) !== null && _role$elasticsearch$r !== void 0 ? _role$elasticsearch$r : [];
  }, [role]);
  const remoteClusterPrivilegesDisabled = (0, _react.useMemo)(() => {
    const {
      allowRemoteClusterPrivileges
    } = license.getFeatures();
    return !allowRemoteClusterPrivileges;
  }, [license]);
  const isReadOnly = (0, _react.useMemo)(() => !editable || (0, _model.isRoleReadOnly)(role) || remoteClusterPrivilegesDisabled, [role, editable, remoteClusterPrivilegesDisabled]);
  const onRoleChange = (0, _react.useCallback)(remoteCluster => {
    const roleDraft = {
      ...role,
      elasticsearch: {
        ...role.elasticsearch,
        remote_cluster: remoteCluster
      }
    };
    onChange(roleDraft);
  }, [onChange, role]);
  const addRemoteClusterPrivilege = (0, _react.useCallback)(() => {
    const newRemoteClusterPrivileges = [...remoteClusterPrivileges, {
      clusters: [],
      privileges: []
    }];
    onRoleChange(newRemoteClusterPrivileges);
  }, [onRoleChange, remoteClusterPrivileges]);
  const onRemoteClusterPrivilegeChange = (0, _react.useCallback)(privilegeIndex => updatedPrivilege => {
    const newRemoteClusterPrivileges = [...remoteClusterPrivileges];
    newRemoteClusterPrivileges[privilegeIndex] = updatedPrivilege;
    onRoleChange(newRemoteClusterPrivileges);
  }, [onRoleChange, remoteClusterPrivileges]);
  const onRemoteClusterPrivilegeDelete = (0, _react.useCallback)(privilegeIndex => () => {
    const newRemoteClusterPrivileges = [...remoteClusterPrivileges];
    newRemoteClusterPrivileges.splice(privilegeIndex, 1);
    onRoleChange(newRemoteClusterPrivileges);
  }, [onRoleChange, remoteClusterPrivileges]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, remoteClusterPrivileges.map((remoteClusterPrivilege, i) => /*#__PURE__*/_react.default.createElement(_remote_cluster_privileges_form.RemoteClusterPrivilegesForm, {
    key: i,
    isRoleReadOnly: isReadOnly,
    formIndex: i,
    validator: validator,
    availableRemoteClusterPrivileges: availableRemoteClusterPrivileges,
    remoteClusterPrivilege: remoteClusterPrivilege,
    remoteClusters: remoteClusters,
    onChange: onRemoteClusterPrivilegeChange(i),
    onDelete: onRemoteClusterPrivilegeDelete(i),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  })), editable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    onClick: addRemoteClusterPrivilege,
    disabled: remoteClusterPrivilegesDisabled,
    "data-test-subj": "addRemoteClusterPrivilegesButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRole.elasticSearchPrivileges.addRemoteClusterPrivilegesButtonLabel",
    defaultMessage: "Add remote cluster privilege",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 17
    }
  }))), remoteClusterPrivilegesDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.elasticSearchPrivileges.remoteClusterPrivilegesLicenseMissing",
      defaultMessage: "Your license does not allow configuring remote cluster privileges",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 21
      }
    }),
    position: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 17
    }
  })))));
};
exports.RemoteClusterPrivileges = RemoteClusterPrivileges;